/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.template.freemarker.caller;

import freemarker.template.TemplateMethodModel;
import freemarker.template.TemplateModelException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wikbook.template.freemarker.TemplateExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavadocCallerMethod
implements TemplateMethodModel {
    private Map<String, List<List<String>>> details = new HashMap<String, List<List<String>>>();

    public JavadocCallerMethod(Map<String, List<List<String>>> details) {
        this.details = details;
    }

    public Object exec(List list) throws TemplateModelException {
        switch (list.size()) {
            case 0: {
                return this.perform(this.details.get(null));
            }
            case 1: {
                TemplateExpression eh = new TemplateExpression((String)list.get(0));
                return this.perform(this.details.get(eh.getValue()), eh);
            }
        }
        throw new RuntimeException("Cannot have many names");
    }

    private Object perform(List<List<String>> values) {
        return this.perform(values, TemplateExpression.noExpression());
    }

    private Object perform(List<List<String>> values, TemplateExpression e) {
        if (values != null) {
            List<String> builtDoc = this.buildDocValue(values, e.getOutput().equals((Object)TemplateExpression.Output.BLOC));
            switch (e.getOutput()) {
                case LIST: 
                case NONE: {
                    return builtDoc;
                }
                case FLAT: 
                case NOEXPR: {
                    return e.flatStringList(builtDoc).trim();
                }
                case BLOC: {
                    return e.flatStringList(builtDoc);
                }
            }
        }
        if (e.getOutput().equals((Object)TemplateExpression.Output.LIST)) {
            return Collections.emptyList();
        }
        return "";
    }

    private List<String> buildDocValue(List<List<String>> data, boolean isBloc) {
        ArrayList<String> c = new ArrayList<String>();
        for (List<String> lv : data) {
            StringBuffer sb = new StringBuffer();
            for (String v : lv) {
                if (isBloc) {
                    if (sb.length() > 0) {
                        sb.append("\n");
                    }
                    sb.append(v);
                    continue;
                }
                sb.append(v);
            }
            c.add(sb.toString());
        }
        return c;
    }
}

