/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.xwiki;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class PatternFilter {
    private final Pattern pattern;

    private PatternFilter(Pattern pattern) {
        this.pattern = pattern;
    }

    protected abstract void appendMatch(StringBuilder var1, String var2);

    public String filter(String s) {
        Matcher matcher = this.pattern.matcher(s);
        StringBuilder builder = new StringBuilder();
        int pre = 0;
        while (matcher.find()) {
            builder.append(s, pre, matcher.start());
            String propertyName = matcher.group(1);
            this.appendMatch(builder, propertyName);
            pre = matcher.end();
        }
        builder.append(s, pre, s.length());
        return builder.toString();
    }

    public static abstract class Properties
    extends PatternFilter {
        private static final Pattern PATTERN = Pattern.compile("\\$\\[(\\w[\\w\\.]*)\\]");

        protected Properties() {
            super(PATTERN);
        }

        protected void appendMatch(StringBuilder builder, String match) {
            String propertyValue = this.resolveProperty(match);
            if (propertyValue != null) {
                builder.append(propertyValue);
            } else {
                builder.append("$[").append(match).append("]");
            }
        }

        protected abstract String resolveProperty(String var1);
    }

    public static class Escape
    extends PatternFilter {
        private static final Pattern PATTERN = Pattern.compile("\\\\(.)");
        private final String before;
        private final String after;

        protected Escape(String before, String after) {
            super(PATTERN);
            this.before = before;
            this.after = after;
        }

        protected void appendMatch(StringBuilder builder, String match) {
            if ("\\".equals(match)) {
                builder.append("\\");
            } else {
                if (this.before != null) {
                    builder.append(this.before);
                }
                builder.append(match);
                if (this.before != null) {
                    builder.append(this.after);
                }
            }
        }
    }
}

