/*
 * Decompiled with CFR 0.152.
 */
package org.wikimodel.wem;

import org.wikimodel.wem.WikiReference;

public abstract class ReferenceHandler {
    public static final String PREFIX_DOWNLOAD = "download:";
    public static final String PREFIX_IMAGE = "image:";

    public void handle(String ref) {
        ref = ref.trim();
        int idx = ref.indexOf(32);
        String label = "";
        if (idx > 0) {
            label = ref.substring(idx).trim();
            ref = ref.substring(0, idx);
        }
        this.handle(ref, label);
    }

    private void handle(String link, String label) {
        if (link.startsWith(PREFIX_IMAGE)) {
            link = link.substring(PREFIX_IMAGE.length());
            if (label == null || "".equals(label)) {
                label = link;
            }
            this.handleImage(link, label);
        } else if (link.startsWith(PREFIX_DOWNLOAD)) {
            link = link.substring(PREFIX_DOWNLOAD.length());
            if (label == null || "".equals(label)) {
                label = link;
            }
            this.handleDownload(link, label);
        } else {
            if (label == null || "".equals(label)) {
                label = link;
            }
            this.handleReference(link, label);
        }
    }

    public void handle(WikiReference ref) {
        this.handle(ref.getLink(), ref.getLabel());
    }

    protected void handleDownload(String ref, String label) {
        this.handleReference(ref, label);
    }

    protected abstract void handleImage(String var1, String var2);

    protected abstract void handleReference(String var1, String var2);
}

