/*
 * Decompiled with CFR 0.152.
 */
package org.wikimodel.wem.impl;

import java.util.Stack;
import org.wikimodel.wem.IWemListener;
import org.wikimodel.wem.WikiParameters;
import org.wikimodel.wem.WikiReference;
import org.wikimodel.wem.WikiStyle;
import org.wikimodel.wem.impl.IWikiScannerContext;
import org.wikimodel.wem.impl.InlineState;
import org.wikimodel.wem.impl.InternalWikiScannerContext;

public class WikiScannerContext
implements IWikiScannerContext {
    private final IWemListener fListener;
    private final Stack<IWikiScannerContext> fStack = new Stack();

    public WikiScannerContext(IWemListener listener) {
        this.fListener = listener;
    }

    private InternalWikiScannerContext pushContext() {
        InternalWikiScannerContext context = (InternalWikiScannerContext)this.getContext();
        if (context != null) {
            context.checkBlockContainer();
            context.closeFormat();
        }
        context = new InternalWikiScannerContext(this.fListener);
        this.fStack.push(context);
        return context;
    }

    public void beginDocument() {
        InternalWikiScannerContext context = this.pushContext();
        context.beginDocument();
    }

    public void beginDocument(WikiParameters params) {
        InternalWikiScannerContext context = this.pushContext();
        context.beginDocument(params);
    }

    public void beginHeader(int level) {
        this.getContext().beginHeader(level);
    }

    public void beginHeader(int level, WikiParameters params) {
        this.getContext().beginHeader(level, params);
    }

    public void beginInfo(String type, WikiParameters params) {
        this.getContext().beginInfo(type, params);
    }

    public void beginList() {
        this.getContext().beginList();
    }

    public void beginList(WikiParameters params) {
        this.getContext().beginList(params);
    }

    public void beginListItem(String item) {
        this.getContext().beginListItem(item);
    }

    public void beginListItem(String item, WikiParameters params) {
        this.getContext().beginListItem(item, params);
    }

    public void beginParagraph() {
        this.getContext().beginParagraph();
    }

    public void beginParagraph(WikiParameters params) {
        this.getContext().beginParagraph(params);
    }

    public void beginPropertyBlock(String property, boolean doc) {
        this.getContext().beginPropertyBlock(property, doc);
    }

    public void beginPropertyInline(String str) {
        this.getContext().beginPropertyInline(str);
    }

    public void beginQuot() {
        this.getContext().beginQuot();
    }

    public void beginQuot(WikiParameters params) {
        this.getContext().beginQuot(params);
    }

    public void beginQuotLine(int depth) {
        this.getContext().beginQuotLine(depth);
    }

    public void beginTable() {
        this.getContext().beginTable();
    }

    public void beginTable(WikiParameters params) {
        this.getContext().beginTable(params);
    }

    public void beginTableCell(boolean headCell) {
        this.getContext().beginTableCell(headCell);
    }

    public void beginTableCell(boolean headCell, WikiParameters params) {
        this.getContext().beginTableCell(headCell, params);
    }

    public void beginTableRow(boolean headCell) {
        this.getContext().beginTableRow(headCell);
    }

    public void beginTableRow(boolean head, WikiParameters rowParams, WikiParameters cellParams) {
        this.getContext().beginTableRow(head, rowParams, cellParams);
    }

    public void beginTableRow(WikiParameters rowParams) {
        this.getContext().beginTableRow(rowParams);
    }

    public boolean canApplyDefintionSplitter() {
        return this.getContext().canApplyDefintionSplitter();
    }

    public boolean checkFormatStyle(WikiStyle style) {
        return this.getContext().checkFormatStyle(style);
    }

    public void closeBlock() {
        this.getContext().closeBlock();
    }

    public void endDocument() {
        this.getContext().endDocument();
        this.fStack.pop();
    }

    public void endHeader() {
        this.getContext().endHeader();
    }

    public void endInfo() {
        this.getContext().endInfo();
    }

    public void endList() {
        this.getContext().endList();
    }

    public void endListItem() {
        this.getContext().endListItem();
    }

    public void endParagraph() {
        this.getContext().endParagraph();
    }

    public void endPropertyBlock() {
        this.getContext().endPropertyBlock();
    }

    public void endPropertyInline() {
        this.getContext().endPropertyInline();
    }

    public void endQuot() {
        this.getContext().endQuot();
    }

    public void endQuotLine() {
        this.getContext().endQuotLine();
    }

    public void endTable() {
        this.getContext().endTable();
    }

    public void endTableCell() {
        this.getContext().endTableCell();
    }

    public void endTableExplicit() {
        this.getContext().endTableExplicit();
    }

    public void endTableRow() {
        this.getContext().endTableRow();
    }

    public IWikiScannerContext getContext() {
        if (!this.fStack.isEmpty()) {
            return this.fStack.peek();
        }
        InternalWikiScannerContext context = new InternalWikiScannerContext(this.fListener);
        this.fStack.push(context);
        return context;
    }

    public InlineState getInlineState() {
        return this.getContext().getInlineState();
    }

    public int getTableCellCounter() {
        return this.getContext().getTableCellCounter();
    }

    public int getTableRowCounter() {
        return this.getContext().getTableRowCounter();
    }

    public boolean isInDefinitionList() {
        return this.getContext().isInDefinitionList();
    }

    public boolean isInDefinitionTerm() {
        return this.getContext().isInDefinitionTerm();
    }

    public boolean isInHeader() {
        return this.getContext().isInHeader();
    }

    public boolean isInInlineProperty() {
        return this.getContext().isInInlineProperty();
    }

    public boolean isInList() {
        return this.getContext().isInList();
    }

    public boolean isInTable() {
        return this.getContext().isInTable();
    }

    public boolean isInTableCell() {
        return this.getContext().isInTableCell();
    }

    public boolean isInTableRow() {
        return this.getContext().isInTableRow();
    }

    public void onDefinitionListItemSplit() {
        this.getContext().onDefinitionListItemSplit();
    }

    public void onEmptyLines(int count) {
        this.getContext().onEmptyLines(count);
    }

    public void onEscape(String str) {
        this.getContext().onEscape(str);
    }

    public void onExtensionBlock(String extensionName, WikiParameters params) {
        this.getContext().onExtensionBlock(extensionName, params);
    }

    public void onExtensionInline(String extensionName, WikiParameters params) {
        this.getContext().onExtensionInline(extensionName, params);
    }

    public void onFormat(WikiParameters params) {
        this.getContext().onFormat(params);
    }

    public void onFormat(WikiStyle wikiStyle) {
        this.getContext().onFormat(wikiStyle);
    }

    public void beginFormat(WikiParameters params) {
        this.getContext().beginFormat(params);
    }

    public void beginFormat(WikiStyle wikiStyle) {
        this.getContext().beginFormat(wikiStyle);
    }

    public void endFormat(WikiParameters params) {
        this.getContext().endFormat(params);
    }

    public void endFormat(WikiStyle wikiStyle) {
        this.getContext().endFormat(wikiStyle);
    }

    public void onFormat(WikiStyle wikiStyle, boolean forceClose) {
        this.getContext().onFormat(wikiStyle, forceClose);
    }

    public void onHorizontalLine() {
        this.getContext().onHorizontalLine();
    }

    public void onHorizontalLine(WikiParameters params) {
        this.getContext().onHorizontalLine(params);
    }

    public void onImage(String ref) {
        this.getContext().onImage(ref);
    }

    public void onImage(WikiReference ref) {
        this.getContext().onImage(ref);
    }

    public void onLineBreak() {
        this.getContext().onLineBreak();
    }

    public void onMacro(String name, WikiParameters params, String content) {
        this.getContext().onMacro(name, params, content);
    }

    public void onMacro(String macroName, WikiParameters params, String content, boolean inline) {
        if (inline) {
            this.onMacroInline(macroName, params, content);
        } else {
            this.onMacroBlock(macroName, params, content);
        }
    }

    public void onMacroBlock(String macroName, WikiParameters params, String content) {
        this.getContext().onMacroBlock(macroName, params, content);
    }

    public void onMacroInline(String macroName, WikiParameters params, String content) {
        this.getContext().onMacroInline(macroName, params, content);
    }

    public void onNewLine() {
        this.getContext().onNewLine();
    }

    public void onQuotLine(int depth) {
        this.getContext().onQuotLine(depth);
    }

    public void onReference(String ref) {
        this.getContext().onReference(ref);
    }

    public void onReference(WikiReference ref) {
        this.getContext().onReference(ref);
    }

    public void onSpace(String str) {
        this.getContext().onSpace(str);
    }

    public void onSpecialSymbol(String str) {
        this.getContext().onSpecialSymbol(str);
    }

    public void onTableCaption(String str) {
        this.getContext().onTableCaption(str);
    }

    public void onTableCell(boolean headCell) {
        this.getContext().onTableCell(headCell);
    }

    public void onTableCell(boolean head, WikiParameters cellParams) {
        this.getContext().onTableCell(head, cellParams);
    }

    public void onTableRow(WikiParameters params) {
        this.getContext().onTableRow(params);
    }

    public void onVerbatim(String str, WikiParameters params) {
        this.getContext().onVerbatim(str, params);
    }

    public void onVerbatim(String str, boolean inline) {
        this.getContext().onVerbatim(str, inline);
    }

    public void onVerbatim(String str, boolean inline, WikiParameters params) {
        this.getContext().onVerbatim(str, inline, params);
    }

    public void onWord(String str) {
        this.getContext().onWord(str);
    }
}

