/*
 * Decompiled with CFR 0.152.
 */
package org.wikimodel.wem.mediawiki;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.wikimodel.wem.WikiParameter;
import org.wikimodel.wem.WikiParameters;
import org.wikimodel.wem.WikiReference;
import org.wikimodel.wem.WikiReferenceParser;

public class MediaWikiReferenceParser
extends WikiReferenceParser {
    private static final List<String> format = Arrays.asList("border", "frame", "thumb", "frameless");
    private static final List<String> align = Arrays.asList("left", "right", "center", "none");
    private static final List<String> valign = Arrays.asList("baseline", "sub", "super", "top", "text-top", "middle", "bottom", "text-bottom");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public WikiReference parse(String str) {
        if (str.contains("|") && !str.endsWith("|")) {
            String reference = str.trim().substring(0, str.indexOf(124));
            String label = str.trim().substring(str.indexOf(124) + 1);
            int pipeCount = str.replaceAll("[^|]", "").length();
            if (!reference.toLowerCase().startsWith("file:") || pipeCount <= 1) {
                if (!reference.toLowerCase().startsWith("image:")) return new WikiReference(reference, label);
                if (pipeCount <= 0) return new WikiReference(reference, label);
            }
            WikiParameters params = this.generateImageParams(label);
            reference = reference.trim().substring(reference.indexOf(":") + 1);
            return new WikiReference(reference, params);
        }
        if (-1 == str.trim().indexOf(32)) return new WikiReference(str.trim());
        if (!str.contains("://")) {
            if (!str.contains("mailto:")) return new WikiReference(str.trim());
        }
        String link = str.substring(0, str.indexOf(32)).trim();
        String label = str.substring(str.indexOf(32) + 1).trim();
        return new WikiReference(link, label);
    }

    private WikiParameters generateImageParams(String paramString) {
        String[] params;
        ArrayList<WikiParameter> paramsList = new ArrayList<WikiParameter>();
        for (String param : params = paramString.split("[|]")) {
            if (param.indexOf("=") != -1) {
                String[] p = param.split("[=]");
                paramsList.add(new WikiParameter(p[0], p[1]));
                continue;
            }
            if (format.contains(param.toLowerCase())) {
                paramsList.add(new WikiParameter("format", param));
                continue;
            }
            if (align.contains(param.toLowerCase())) {
                paramsList.add(new WikiParameter("align", param));
                continue;
            }
            if (valign.contains(param.toLowerCase())) {
                paramsList.add(new WikiParameter("valign", param));
                continue;
            }
            if (param.toLowerCase().matches("[0-9]*px")) {
                paramsList.add(new WikiParameter("width", param));
                continue;
            }
            if (param.toLowerCase().matches("[0-9]*x[0-9]*px")) {
                paramsList.add(new WikiParameter("width", param.substring(0, param.indexOf("x")) + "px"));
                paramsList.add(new WikiParameter("height", param.substring(param.indexOf("x") + 1)));
                continue;
            }
            paramsList.add(new WikiParameter("alt", param));
        }
        return new WikiParameters(paramsList);
    }
}

