/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServerConnection;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.JMXContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.client.protocol.metadata.Servlet;
import org.jboss.as.arquillian.container.Authentication;
import org.jboss.as.arquillian.container.NetworkUtils;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.logging.Logger;

public class ManagementClient
implements Closeable {
    private static final Logger logger = Logger.getLogger(ManagementClient.class);
    private static final String SUBDEPLOYMENT = "subdeployment";
    private static final String UNDERTOW = "undertow";
    private static final String NAME = "name";
    private static final String SERVLET = "servlet";
    private static final String POSTFIX_WEB = ".war";
    private static final String POSTFIX_EAR = ".ear";
    private static final ModelNode UNDERTOW_SUBSYSTEM_ADDRESS = new ModelNode().add("subsystem", "undertow");
    private final String mgmtAddress;
    private final int mgmtPort;
    private final String mgmtProtocol;
    private final ModelControllerClient client;
    private boolean initialized = false;
    private URI webUri;
    private URI ejbUri;
    private ModelNode undertowSubsystem = null;
    private MBeanServerConnection connection;
    private JMXConnector connector;
    private boolean undertowSubsystemPresent = false;
    private boolean closed = false;

    public ManagementClient(ModelControllerClient client, String mgmtAddress, int managementPort, String protocol) {
        if (client == null) {
            throw new IllegalArgumentException("Client must be specified");
        }
        this.client = client;
        this.mgmtAddress = mgmtAddress;
        this.mgmtPort = managementPort;
        this.mgmtProtocol = protocol;
    }

    public ModelControllerClient getControllerClient() {
        this.checkState();
        return this.client;
    }

    private void init() {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                ManagementClient.this.checkState();
                if (!ManagementClient.this.initialized) {
                    ManagementClient.this.initialized = true;
                    try {
                        URI webUri;
                        ModelNode op = Operations.createReadResourceOperation((ModelNode)UNDERTOW_SUBSYSTEM_ADDRESS, (boolean)true);
                        ModelNode result = ManagementClient.this.client.execute(op);
                        ManagementClient.this.undertowSubsystemPresent = Operations.isSuccessfulOutcome((ModelNode)result);
                        if (ManagementClient.this.undertowSubsystemPresent) {
                            ManagementClient.this.undertowSubsystem = Operations.readResult((ModelNode)result);
                        }
                        try {
                            webUri = new URI("http://localhost:8080");
                        }
                        catch (URISyntaxException e) {
                            throw new RuntimeException(e);
                        }
                        if (ManagementClient.this.undertowSubsystem != null && ManagementClient.this.undertowSubsystem.hasDefined("server")) {
                            List vhosts = ManagementClient.this.undertowSubsystem.get("server").asPropertyList();
                            ModelNode socketBinding = new ModelNode();
                            if (!vhosts.isEmpty()) {
                                socketBinding = ((Property)vhosts.get(0)).getValue().get(new String[]{"http-listener", "default"}).get("socket-binding");
                            }
                            if (socketBinding.isDefined()) {
                                webUri = ManagementClient.this.getBinding("http", socketBinding.asString());
                            }
                        }
                        ManagementClient.this.webUri = webUri;
                        try {
                            ManagementClient.this.ejbUri = new URI("http-remoting", webUri.getUserInfo(), webUri.getHost(), webUri.getPort(), null, null, null);
                        }
                        catch (URISyntaxException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Could not init arquillian protocol", e);
                    }
                }
                return null;
            }
        });
    }

    public URI getWebUri() {
        this.init();
        return this.webUri;
    }

    public ProtocolMetaData getProtocolMetaData(String deploymentName) {
        this.init();
        ProtocolMetaData metaData = new ProtocolMetaData();
        metaData.addContext((Object)new JMXContext(this.getConnection()));
        if (this.undertowSubsystemPresent) {
            URI webURI = this.getWebUri();
            HTTPContext context = new HTTPContext(webURI.getHost(), webURI.getPort());
            metaData.addContext((Object)context);
            try {
                ModelNode address = new ModelNode();
                address.add("deployment", deploymentName);
                ModelNode deploymentNode = this.readResource(address);
                if (this.isWebArchive(deploymentName)) {
                    this.extractWebArchiveContexts(context, deploymentNode);
                } else if (this.isEnterpriseArchive(deploymentName)) {
                    this.extractEnterpriseArchiveContexts(context, deploymentNode);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return metaData;
    }

    public boolean isServerInRunningState() {
        this.checkState();
        try {
            ModelNode op = new ModelNode();
            op.get("operation").set("read-attribute");
            op.get("address").setEmptyList();
            op.get(NAME).set("server-state");
            ModelNode rsp = this.client.execute(op);
            return "success".equals(rsp.get("outcome").asString()) && !"starting".equals(rsp.get("result").asString()) && !"stopping".equals(rsp.get("result").asString());
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() {
        if (!this.closed) {
            try {
                this.client.close();
                this.closed = true;
            }
            catch (IOException e) {
                throw new RuntimeException("Could not close connection", e);
            }
            finally {
                if (this.connector != null) {
                    try {
                        this.connector.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Could not close JMX connection", e);
                    }
                }
            }
        }
    }

    private static ModelNode defined(ModelNode node, String message) {
        if (!node.isDefined()) {
            throw new IllegalStateException(message);
        }
        return node;
    }

    private URI getBinding(String protocol, String socketBinding) {
        try {
            ModelNode address = new ModelNode();
            address.add("socket-binding-group", "*");
            ModelNode socketBindingGroups = this.readResource(address);
            String socketBindingGroupName = ((ModelNode)socketBindingGroups.asList().get(0)).get("result").get(NAME).asString();
            ModelNode operation = new ModelNode();
            operation.get("address").get("socket-binding-group").set(socketBindingGroupName);
            operation.get("address").get("socket-binding").set(socketBinding);
            operation.get("operation").set("read-resource");
            operation.get("include-runtime").set(true);
            ModelNode binding = this.executeForResult(operation);
            String ip = binding.get("bound-address").asString();
            ip = ManagementClient.formatIP(ip);
            int port = ManagementClient.defined(binding.get("bound-port"), socketBindingGroupName + " -> " + socketBinding + " -> bound-port is undefined").asInt();
            return URI.create(protocol + "://" + NetworkUtils.formatPossibleIpv6Address(ip) + ":" + port);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static String formatIP(String ip) {
        if (ip.contains(":") && ip.contains("%")) {
            ip = ip.split("%")[0];
        }
        if (ip.equals("0.0.0.0")) {
            logger.debug((Object)"WildFly is bound to 0.0.0.0 which is correct, setting client to 127.0.0.1");
            ip = "127.0.0.1";
        }
        return ip;
    }

    private boolean isEnterpriseArchive(String deploymentName) {
        return deploymentName.endsWith(POSTFIX_EAR);
    }

    private boolean isWebArchive(String deploymentName) {
        return deploymentName.endsWith(POSTFIX_WEB);
    }

    private void extractEnterpriseArchiveContexts(HTTPContext context, ModelNode deploymentNode) {
        if (deploymentNode.hasDefined(SUBDEPLOYMENT)) {
            for (ModelNode subdeployment : deploymentNode.get(SUBDEPLOYMENT).asList()) {
                String deploymentName = (String)subdeployment.keys().iterator().next();
                if (!this.isWebArchive(deploymentName)) continue;
                this.extractWebArchiveContexts(context, deploymentName, subdeployment.get(deploymentName));
            }
        }
    }

    private void extractWebArchiveContexts(HTTPContext context, ModelNode deploymentNode) {
        this.extractWebArchiveContexts(context, deploymentNode.get(NAME).asString(), deploymentNode);
    }

    private void extractWebArchiveContexts(HTTPContext context, String deploymentName, ModelNode deploymentNode) {
        ModelNode webSubSystem;
        ModelNode subsystem;
        if (deploymentNode.hasDefined("subsystem") && (subsystem = deploymentNode.get("subsystem")).hasDefined(UNDERTOW) && (webSubSystem = subsystem.get(UNDERTOW)).isDefined() && webSubSystem.hasDefined("context-root")) {
            String contextName = webSubSystem.get("context-root").asString();
            if (webSubSystem.hasDefined(SERVLET)) {
                for (ModelNode servletNode : webSubSystem.get(SERVLET).asList()) {
                    for (String servletName : servletNode.keys()) {
                        context.add(new Servlet(servletName, this.toContextName(contextName)));
                    }
                }
            }
            context.add(new Servlet("default", this.toContextName(contextName)));
        }
    }

    private String toContextName(String deploymentName) {
        String correctedName = deploymentName;
        if (correctedName.startsWith("/")) {
            correctedName = correctedName.substring(1);
        }
        return correctedName;
    }

    private ModelNode readResource(ModelNode address) throws Exception {
        ModelNode operation = new ModelNode();
        operation.get("operation").set("read-resource");
        operation.get("recursive").set("true");
        operation.get("address").set(address);
        return this.executeForResult(operation);
    }

    private ModelNode executeForResult(ModelNode operation) throws Exception {
        this.checkState();
        ModelNode result = this.client.execute(operation);
        this.checkSuccessful(result, operation);
        return result.get("result");
    }

    private void checkSuccessful(ModelNode result, ModelNode operation) throws UnSuccessfulOperationException {
        if (!"success".equals(result.get("outcome").asString())) {
            logger.error((Object)("Operation " + operation + " did not succeed. Result was " + result));
            throw new UnSuccessfulOperationException(result.get("failure-description").toString());
        }
    }

    private MBeanServerConnection getConnection() {
        MBeanServerConnection connection = this.connection;
        if (connection == null) {
            try {
                HashMap<String, Authentication.CallbackHandler> env = new HashMap<String, Authentication.CallbackHandler>();
                if (Authentication.username != null && !Authentication.username.isEmpty()) {
                    env.put(CallbackHandler.class.getName(), Authentication.getCallbackHandler());
                }
                JMXConnector connector = this.connector = JMXConnectorFactory.connect(this.getRemoteJMXURL(), env);
                connection = this.connection = new MBeanConnectionProxy(connector.getMBeanServerConnection());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return connection;
    }

    public JMXServiceURL getRemoteJMXURL() {
        try {
            if (this.mgmtProtocol.equals("http-remoting")) {
                return new JMXServiceURL("service:jmx:remote+http://" + NetworkUtils.formatPossibleIpv6Address(this.mgmtAddress) + ":" + this.mgmtPort);
            }
            if (this.mgmtProtocol.equals("https-remoting")) {
                return new JMXServiceURL("service:jmx:remote+https://" + NetworkUtils.formatPossibleIpv6Address(this.mgmtAddress) + ":" + this.mgmtPort);
            }
            return new JMXServiceURL("service:jmx:remoting-jmx://" + NetworkUtils.formatPossibleIpv6Address(this.mgmtAddress) + ":" + this.mgmtPort);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create JMXServiceURL:" + this, e);
        }
    }

    public int getMgmtPort() {
        return this.mgmtPort;
    }

    public String getMgmtAddress() {
        return NetworkUtils.formatPossibleIpv6Address(this.mgmtAddress);
    }

    public String getMgmtProtocol() {
        return this.mgmtProtocol;
    }

    public URI getRemoteEjbURL() {
        this.init();
        return this.ejbUri;
    }

    private void checkState() {
        if (this.closed) {
            throw new IllegalStateException("The client connection has been closed.");
        }
    }

    private class MBeanConnectionProxy
    implements MBeanServerConnection {
        private MBeanServerConnection connection;

        private MBeanConnectionProxy(MBeanServerConnection connection) {
            this.connection = connection;
        }

        @Override
        public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException, IOException {
            this.checkConnection();
            return this.connection.createMBean(className, name);
        }

        @Override
        public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
            this.checkConnection();
            return this.connection.createMBean(className, name, loaderName);
        }

        @Override
        public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException, IOException {
            this.checkConnection();
            return this.connection.createMBean(className, name, params, signature);
        }

        @Override
        public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
            this.checkConnection();
            return this.connection.createMBean(className, name, loaderName, params, signature);
        }

        @Override
        public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException, IOException {
            this.checkConnection();
            this.connection.unregisterMBean(name);
        }

        @Override
        public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException, IOException {
            try {
                return this.connection.getObjectInstance(name);
            }
            catch (IOException e) {
                this.checkConnection();
                return this.connection.getObjectInstance(name);
            }
        }

        @Override
        public Set<ObjectInstance> queryMBeans(ObjectName name, QueryExp query) throws IOException {
            try {
                return this.connection.queryMBeans(name, query);
            }
            catch (IOException e) {
                this.checkConnection();
                return this.connection.queryMBeans(name, query);
            }
        }

        @Override
        public Set<ObjectName> queryNames(ObjectName name, QueryExp query) throws IOException {
            try {
                return this.connection.queryNames(name, query);
            }
            catch (IOException e) {
                this.checkConnection();
                return this.connection.queryNames(name, query);
            }
        }

        @Override
        public boolean isRegistered(ObjectName name) throws IOException {
            try {
                return this.connection.isRegistered(name);
            }
            catch (IOException e) {
                this.checkConnection();
                return this.connection.isRegistered(name);
            }
        }

        @Override
        public Integer getMBeanCount() throws IOException {
            try {
                return this.connection.getMBeanCount();
            }
            catch (IOException e) {
                this.checkConnection();
                return this.connection.getMBeanCount();
            }
        }

        @Override
        public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IOException {
            try {
                return this.connection.getAttribute(name, attribute);
            }
            catch (IOException e) {
                this.checkConnection();
                return this.connection.getAttribute(name, attribute);
            }
        }

        @Override
        public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException, IOException {
            try {
                return this.connection.getAttributes(name, attributes);
            }
            catch (IOException e) {
                this.checkConnection();
                return this.connection.getAttributes(name, attributes);
            }
        }

        @Override
        public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
            this.checkConnection();
            this.connection.setAttribute(name, attribute);
        }

        @Override
        public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException, IOException {
            this.checkConnection();
            return this.connection.setAttributes(name, attributes);
        }

        @Override
        public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
            this.checkConnection();
            return this.connection.invoke(name, operationName, params, signature);
        }

        @Override
        public String getDefaultDomain() throws IOException {
            try {
                return this.connection.getDefaultDomain();
            }
            catch (IOException e) {
                this.checkConnection();
                return this.connection.getDefaultDomain();
            }
        }

        @Override
        public String[] getDomains() throws IOException {
            try {
                return this.connection.getDomains();
            }
            catch (IOException e) {
                this.checkConnection();
                return this.connection.getDomains();
            }
        }

        @Override
        public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, IOException {
            try {
                this.connection.addNotificationListener(name, listener, filter, handback);
            }
            catch (IOException e) {
                if (!this.checkConnection()) {
                    this.connection.addNotificationListener(name, listener, filter, handback);
                }
                throw e;
            }
        }

        @Override
        public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, IOException {
            try {
                this.connection.addNotificationListener(name, listener, filter, handback);
            }
            catch (IOException e) {
                if (!this.checkConnection()) {
                    this.connection.addNotificationListener(name, listener, filter, handback);
                }
                throw e;
            }
        }

        @Override
        public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
            try {
                this.connection.removeNotificationListener(name, listener);
            }
            catch (IOException e) {
                if (!this.checkConnection()) {
                    this.connection.removeNotificationListener(name, listener);
                }
                throw e;
            }
        }

        @Override
        public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
            try {
                this.connection.removeNotificationListener(name, listener, filter, handback);
            }
            catch (IOException e) {
                if (!this.checkConnection()) {
                    this.connection.removeNotificationListener(name, listener, filter, handback);
                }
                throw e;
            }
        }

        @Override
        public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
            try {
                this.connection.removeNotificationListener(name, listener);
            }
            catch (IOException e) {
                if (!this.checkConnection()) {
                    this.connection.removeNotificationListener(name, listener);
                }
                throw e;
            }
        }

        @Override
        public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
            try {
                this.connection.removeNotificationListener(name, listener, filter, handback);
            }
            catch (IOException e) {
                if (!this.checkConnection()) {
                    this.connection.removeNotificationListener(name, listener, filter, handback);
                }
                throw e;
            }
        }

        @Override
        public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
            try {
                return this.connection.getMBeanInfo(name);
            }
            catch (IOException e) {
                this.checkConnection();
                return this.connection.getMBeanInfo(name);
            }
        }

        @Override
        public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException, IOException {
            try {
                return this.connection.isInstanceOf(name, className);
            }
            catch (IOException e) {
                this.checkConnection();
                return this.connection.isInstanceOf(name, className);
            }
        }

        private boolean checkConnection() {
            try {
                this.connection.getDefaultDomain();
                return true;
            }
            catch (IOException ioe) {
                logger.debug((Object)"JMX connection error.", (Throwable)ioe);
                this.connection = this.reconnect();
                return false;
            }
        }

        private MBeanServerConnection reconnect() {
            try {
                HashMap<String, Authentication.CallbackHandler> env = new HashMap<String, Authentication.CallbackHandler>();
                env.put(CallbackHandler.class.getName(), Authentication.getCallbackHandler());
                JMXConnector connector = ManagementClient.this.connector = JMXConnectorFactory.connect(ManagementClient.this.getRemoteJMXURL(), env);
                this.connection = connector.getMBeanServerConnection();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this.connection;
        }
    }

    private static class UnSuccessfulOperationException
    extends Exception {
        private static final long serialVersionUID = 1L;

        UnSuccessfulOperationException(String message) {
            super(message);
        }
    }
}

