/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jboss.arquillian.container.spi.Container;
import org.jboss.arquillian.container.spi.client.deployment.DeploymentDescription;
import org.jboss.arquillian.container.spi.context.ContainerContext;
import org.jboss.arquillian.container.spi.event.container.AfterUnDeploy;
import org.jboss.arquillian.container.spi.event.container.BeforeDeploy;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.test.spi.TestEnricher;
import org.jboss.arquillian.test.spi.context.ClassContext;
import org.jboss.arquillian.test.spi.event.enrichment.AfterEnrichment;
import org.jboss.arquillian.test.spi.event.enrichment.BeforeEnrichment;
import org.jboss.arquillian.test.spi.event.enrichment.EnrichmentEvent;
import org.jboss.arquillian.test.spi.event.suite.AfterClass;
import org.jboss.arquillian.test.spi.event.suite.BeforeClass;
import org.jboss.as.arquillian.api.ServerSetup;
import org.jboss.as.arquillian.api.ServerSetupTask;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.logging.Logger;

public class ServerSetupObserver {
    private static final Logger log = Logger.getLogger(ServerSetupObserver.class);
    @Inject
    private Instance<ContainerContext> containerContext;
    @Inject
    private Instance<ManagementClient> managementClient;
    @Inject
    private Instance<ClassContext> classContextInstance;
    @Inject
    private Instance<ServiceLoader> serviceLoader;
    @Inject
    private Event<EnrichmentEvent> enrichmentEvent;
    private final Map<String, ServerSetupTaskHolder> setupTasks = new HashMap<String, ServerSetupTaskHolder>();
    private boolean afterClassRun = false;

    public synchronized void handleBeforeClass(@Observes BeforeClass beforeClass) {
        this.afterClassRun = false;
    }

    public synchronized void handleBeforeDeployment(@Observes BeforeDeploy event, Container container) throws Throwable {
        String containerName = container.getName();
        if (this.setupTasks.containsKey(containerName)) {
            this.setupTasks.get((Object)containerName).deployments.add(event.getDeployment());
            return;
        }
        ClassContext classContext = (ClassContext)this.classContextInstance.get();
        if (classContext == null) {
            return;
        }
        Class currentClass = (Class)classContext.getActiveId();
        ServerSetup setup = currentClass.getAnnotation(ServerSetup.class);
        if (setup == null) {
            return;
        }
        ManagementClient client = (ManagementClient)this.managementClient.get();
        ServerSetupTaskHolder holder = new ServerSetupTaskHolder(client, container.getName());
        this.executeSetup(holder, setup, containerName, event.getDeployment());
    }

    public synchronized void afterTestClass(@Observes AfterClass afterClass) throws Exception {
        if (this.setupTasks.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<String, ServerSetupTaskHolder>> iter = this.setupTasks.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, ServerSetupTaskHolder> entry = iter.next();
            ServerSetupTaskHolder holder = entry.getValue();
            if (!holder.deployments.isEmpty()) continue;
            entry.getValue().tearDown(entry.getKey());
            iter.remove();
        }
        this.afterClassRun = true;
    }

    public synchronized void handleAfterUndeploy(@Observes AfterUnDeploy afterDeploy, Container container) throws Exception {
        String containerName = container.getName();
        ServerSetupTaskHolder holder = this.setupTasks.get(containerName);
        if (holder == null) {
            return;
        }
        if (holder.deployments.remove(afterDeploy.getDeployment()) && this.afterClassRun && holder.deployments.isEmpty()) {
            holder.tearDown(containerName);
            this.setupTasks.remove(containerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSetup(ServerSetupTaskHolder holder, ServerSetup setup, String containerName, DeploymentDescription deployment) throws Exception {
        holder.deployments.add(deployment);
        this.setupTasks.put(containerName, holder);
        try {
            holder.setup(setup, containerName);
        }
        catch (Throwable t) {
            Throwable toThrow = t;
            ServerSetupTask failedSetup = null;
            try {
                failedSetup = holder.setupTasks.pollLast();
                holder.tearDown(containerName);
            }
            catch (Exception logged) {
                String className = failedSetup != null ? failedSetup.getClass().getName() : ServerSetupTask.class.getSimpleName();
                String message = String.format("Failed tearing down ServerSetupTasks after a failed assumption in %s.setup()", className);
                toThrow.addSuppressed(new RuntimeException(message, logged));
                log.errorf((Throwable)logged, message, new Object[0]);
            }
            finally {
                holder.deployments.remove(deployment);
                if (holder.deployments.isEmpty()) {
                    this.setupTasks.remove(containerName);
                }
            }
            if (toThrow instanceof Exception) {
                throw (Exception)toThrow;
            }
            if (toThrow instanceof Error) {
                throw (Error)toThrow;
            }
            throw new AssertionError("Failed to invoke a ServerSetupTask.", toThrow);
        }
    }

    private class ServerSetupTaskHolder {
        private final ManagementClient client;
        private final Deque<ServerSetupTask> setupTasks;
        private final Set<DeploymentDescription> deployments;
        private final String containerName;

        private ServerSetupTaskHolder(ManagementClient client, String containerName) {
            this.client = client;
            this.setupTasks = new ArrayDeque<ServerSetupTask>();
            this.deployments = new HashSet<DeploymentDescription>();
            this.containerName = containerName;
        }

        void setup(ServerSetup setup, String containerName) throws Throwable {
            Class<? extends ServerSetupTask>[] classes;
            for (Class<? extends ServerSetupTask> clazz : classes = setup.value()) {
                Constructor<? extends ServerSetupTask> ctor = clazz.getDeclaredConstructor(new Class[0]);
                ctor.setAccessible(true);
                ServerSetupTask task = ctor.newInstance(new Object[0]);
                this.enrich(task, clazz.getMethod("setup", ManagementClient.class, String.class));
                this.setupTasks.add(task);
                task.setup(this.client, containerName);
            }
        }

        public void tearDown(String containerName) {
            if (this.client.isClosed()) {
                log.errorf("The container '%s' may have been stopped. The management client has been closed and tearing down setup tasks is not possible.", (Object)containerName);
            } else {
                ServerSetupTask task;
                while ((task = this.setupTasks.pollLast()) != null) {
                    try {
                        this.enrich(task, task.getClass().getMethod("tearDown", ManagementClient.class, String.class));
                        task.tearDown(this.client, containerName);
                    }
                    catch (Throwable e) {
                        log.errorf(e, "Setup task failed during tear down. Offending class '%s'", (Object)task);
                    }
                }
            }
        }

        public String toString() {
            return ServerSetupTaskHolder.class.getName() + "[setupTasks=" + this.setupTasks + ", deployments" + this.deployments + "]";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void enrich(ServerSetupTask task, Method method) {
            try {
                ((ContainerContext)ServerSetupObserver.this.containerContext.get()).activate((Object)this.containerName);
                ServerSetupObserver.this.enrichmentEvent.fire((Object)new BeforeEnrichment((Object)task, method));
                Collection testEnrichers = ((ServiceLoader)ServerSetupObserver.this.serviceLoader.get()).all(TestEnricher.class);
                for (TestEnricher enricher : testEnrichers) {
                    enricher.enrich((Object)task);
                }
                ServerSetupObserver.this.enrichmentEvent.fire((Object)new AfterEnrichment((Object)task, method));
            }
            finally {
                ((ContainerContext)ServerSetupObserver.this.containerContext.get()).deactivate();
            }
        }
    }
}

