/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.setup;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.as.arquillian.api.ServerSetupTask;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.wildfly.plugin.tools.server.ServerManager;

public class SnapshotServerSetupTask
implements ServerSetupTask {
    private static final Logger LOGGER = Logger.getLogger(SnapshotServerSetupTask.class);
    private final Map<String, AutoCloseable> snapshots = new ConcurrentHashMap<String, AutoCloseable>();
    @ArquillianResource
    private ServerManager serverManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setup(ManagementClient managementClient, String containerId) throws Exception {
        try {
            String fileName = this.serverManager.takeSnapshot();
            AutoCloseable restorer = () -> {
                ModelNode op = Operations.createOperation((String)"reload");
                op.get("server-config").set(fileName);
                this.serverManager.executeReload(op);
                this.serverManager.waitFor(this.timeout(), TimeUnit.SECONDS);
                ModelNode result1 = this.serverManager.client().execute(Operations.createOperation((String)"write-config"));
                if (!Operations.isSuccessfulOutcome((ModelNode)result1)) {
                    throw new RuntimeException("Failed to write config after restoring from snapshot " + Operations.getFailureDescription((ModelNode)result1).asString());
                }
            };
            this.snapshots.put(containerId, restorer);
            try {
                this.doSetup(managementClient, containerId);
            }
            catch (Throwable e) {
                try {
                    restorer.close();
                }
                catch (Throwable t) {
                    LOGGER.warnf(t, "Failed to restore snapshot for %s: %s", (Object)this.getClass().getName(), (Object)fileName);
                }
                throw e;
            }
        }
        finally {
            this.serverManager.reloadIfRequired(this.timeout(), TimeUnit.SECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void tearDown(ManagementClient managementClient, String containerId) throws Exception {
        try {
            this.beforeRestore(managementClient, containerId);
        }
        finally {
            try {
                AutoCloseable snapshot = this.snapshots.remove(containerId);
                if (snapshot != null) {
                    snapshot.close();
                }
            }
            finally {
                this.nonManagementCleanUp();
            }
        }
    }

    protected void doSetup(ManagementClient managementClient, String containerId) throws Exception {
    }

    protected void beforeRestore(ManagementClient managementClient, String containerId) throws Exception {
    }

    protected void nonManagementCleanUp() throws Exception {
    }

    protected long timeout() {
        return 10L;
    }
}

