/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jboss.arquillian.container.test.spi.util.ServiceLoader;
import org.jboss.arquillian.testenricher.msc.ServiceTargetAssociation;
import org.jboss.as.arquillian.service.ArquillianConfigServiceCustomizer;
import org.jboss.as.arquillian.service.ArquillianService;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.modules.Module;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class ArquillianConfig
implements Service<ArquillianConfig> {
    private final List<ArquillianConfigServiceCustomizer> serviceCustomizers = new ArrayList<ArquillianConfigServiceCustomizer>();
    private final InjectedValue<ArquillianService> arquillianService = new InjectedValue();
    private final InjectedValue<DeploymentUnit> deploymentUnit = new InjectedValue();
    private final ServiceName serviceName;
    private final List<String> testClasses = new ArrayList<String>();

    private static ServiceName getServiceName(String deploymentUnitName) {
        return ServiceName.JBOSS.append(new String[]{"arquillian", "config", deploymentUnitName});
    }

    ArquillianConfig(Set<String> testClasses, String deploymentUnitName) {
        this.serviceName = ArquillianConfig.getServiceName(deploymentUnitName);
        this.testClasses.addAll(testClasses);
        for (ArquillianConfigServiceCustomizer customizer : ServiceLoader.load(ArquillianConfigServiceCustomizer.class)) {
            this.serviceCustomizers.add(customizer);
        }
    }

    ServiceBuilder<ArquillianConfig> addDeps(ServiceBuilder<ArquillianConfig> builder, ServiceController<?> depController) {
        for (ArquillianConfigServiceCustomizer customizer : this.serviceCustomizers) {
            customizer.customizeService(this, builder, depController);
        }
        return builder;
    }

    InjectedValue<DeploymentUnit> getDeploymentUnit() {
        return this.deploymentUnit;
    }

    ServiceName getServiceName() {
        return this.serviceName;
    }

    List<String> getTestClasses() {
        return Collections.unmodifiableList(this.testClasses);
    }

    Class<?> loadClass(String className) throws ClassNotFoundException {
        if (!this.testClasses.contains(className)) {
            throw new ClassNotFoundException("Class '" + className + "' not found in: " + this.testClasses);
        }
        Module module = (Module)((DeploymentUnit)this.deploymentUnit.getValue()).getAttachment(Attachments.MODULE);
        Class testClass = module.getClassLoader().loadClass(className);
        for (ArquillianConfigServiceCustomizer customizer : this.serviceCustomizers) {
            customizer.customizeLoadClass((DeploymentUnit)this.deploymentUnit.getValue(), testClass);
        }
        return testClass;
    }

    public InjectedValue<ArquillianService> getArquillianService() {
        return this.arquillianService;
    }

    public synchronized void start(StartContext context) throws StartException {
        ((ArquillianService)this.arquillianService.getValue()).registerArquillianConfig(this);
        for (String testClass : this.testClasses) {
            ServiceTargetAssociation.setServiceTarget((String)testClass, (ServiceTarget)context.getChildTarget());
        }
    }

    public synchronized void stop(StopContext context) {
        context.getController().setMode(ServiceController.Mode.REMOVE);
        ((ArquillianService)this.arquillianService.getValue()).unregisterArquillianConfig(this);
        for (String testClass : this.testClasses) {
            ServiceTargetAssociation.clearServiceTarget((String)testClass);
        }
    }

    public synchronized ArquillianConfig getValue() {
        return this;
    }

    public String toString() {
        String uname = this.serviceName.getSimpleName();
        String sname = this.serviceName.getCanonicalName();
        return "ArquillianConfig[service=" + sname + ",unit=" + uname + ",tests=" + this.testClasses + "]";
    }
}

