/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.service;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import org.jboss.arquillian.container.test.spi.TestRunner;
import org.jboss.arquillian.protocol.jmx.JMXTestRunner;
import org.jboss.arquillian.test.spi.TestResult;
import org.jboss.as.arquillian.service.ArquillianConfig;
import org.jboss.as.arquillian.service.ArquillianConfigBuilder;
import org.jboss.as.arquillian.service.ContextManager;
import org.jboss.as.arquillian.service.ContextManagerBuilder;
import org.jboss.as.jmx.MBeanServerService;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.deployment.Services;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ArquillianService
implements Service<ArquillianService> {
    public static final String TEST_CLASS_PROPERTY = "org.jboss.as.arquillian.testClass";
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"arquillian", "testrunner"});
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.arquillian");
    private final InjectedValue<MBeanServer> injectedMBeanServer = new InjectedValue();
    private final Set<ArquillianConfig> deployedTests = new HashSet<ArquillianConfig>();
    private volatile JMXTestRunner jmxTestRunner;
    private volatile AbstractServiceListener<Object> listener;

    public static void addService(ServiceTarget serviceTarget) {
        ArquillianService service = new ArquillianService();
        ServiceBuilder builder = serviceTarget.addService(SERVICE_NAME, (Service)service);
        builder.addDependency(MBeanServerService.SERVICE_NAME, MBeanServer.class, service.injectedMBeanServer);
        builder.setInitialMode(ServiceController.Mode.ACTIVE);
        builder.install();
    }

    public synchronized void start(StartContext context) throws StartException {
        log.debugf("Starting Arquillian Test Runner", new Object[0]);
        MBeanServer mbeanServer = (MBeanServer)this.injectedMBeanServer.getValue();
        try {
            this.jmxTestRunner = new ExtendedJMXTestRunner();
            this.jmxTestRunner.registerMBean(mbeanServer);
        }
        catch (Throwable t) {
            throw new StartException("Failed to start Arquillian Test Runner", t);
        }
        this.listener = new ArquillianServiceListener(context.getChildTarget());
        context.getController().getServiceContainer().addListener(this.listener);
    }

    public synchronized void stop(StopContext context) {
        log.debugf("Stopping Arquillian Test Runner", new Object[0]);
        try {
            if (this.jmxTestRunner != null) {
                this.jmxTestRunner.unregisterMBean((MBeanServer)this.injectedMBeanServer.getValue());
            }
        }
        catch (Exception ex) {
            log.errorf((Throwable)ex, "Cannot stop Arquillian Test Runner", new Object[0]);
        }
        finally {
            context.getController().getServiceContainer().removeListener(this.listener);
        }
    }

    public synchronized ArquillianService getValue() throws IllegalStateException {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerArquillianConfig(ArquillianConfig arqConfig) {
        Set<ArquillianConfig> set = this.deployedTests;
        synchronized (set) {
            log.debugf("Register Arquillian config: %s", (Object)arqConfig.getServiceName());
            this.deployedTests.add(arqConfig);
            this.deployedTests.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterArquillianConfig(ArquillianConfig arqConfig) {
        Set<ArquillianConfig> set = this.deployedTests;
        synchronized (set) {
            log.debugf("Unregister Arquillian config: %s", (Object)arqConfig.getServiceName());
            this.deployedTests.remove(arqConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArquillianConfig getArquillianConfig(String className, long timeout) {
        Set<ArquillianConfig> set = this.deployedTests;
        synchronized (set) {
            log.debugf("Getting Arquillian config for: %s", (Object)className);
            for (ArquillianConfig arqConfig : this.deployedTests) {
                for (String aux : arqConfig.getTestClasses()) {
                    if (!aux.equals(className)) continue;
                    log.debugf("Found Arquillian config for: %s", (Object)className);
                    return arqConfig;
                }
            }
            if (timeout <= 0L) {
                throw new IllegalStateException("Cannot obtain Arquillian config for: " + className);
            }
            try {
                log.debugf("Waiting on Arquillian config for: %s", (Object)className);
                this.deployedTests.wait(timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.getArquillianConfig(className, -1L);
    }

    private static class ArquillianServiceListener
    extends AbstractServiceListener<Object> {
        private ServiceTarget serviceTarget;

        private ArquillianServiceListener(ServiceTarget serviceTarget) {
            this.serviceTarget = serviceTarget;
        }

        public void transition(ServiceController<? extends Object> serviceController, ServiceController.Transition transition) {
            switch (transition.getAfter()) {
                case UP: {
                    ServiceName serviceName = serviceController.getName();
                    String simpleName = serviceName.getSimpleName();
                    if (!Services.JBOSS_DEPLOYMENT.isParentOf(serviceName) || !simpleName.equals(Phase.INSTALL.toString())) break;
                    ServiceName parentName = serviceName.getParent();
                    ServiceController parentController = serviceController.getServiceContainer().getService(parentName);
                    DeploymentUnit depUnit = (DeploymentUnit)parentController.getValue();
                    ArquillianConfig arqConfig = ArquillianConfigBuilder.processDeployment(depUnit);
                    if (arqConfig == null) break;
                    log.infof("Arquillian deployment detected: %s", (Object)arqConfig);
                    ServiceBuilder builder = this.serviceTarget.addService(arqConfig.getServiceName(), (Service)arqConfig).addDependency(SERVICE_NAME, ArquillianService.class, arqConfig.getArquillianService()).addDependency(parentController.getName(), DeploymentUnit.class, arqConfig.getDeploymentUnit());
                    arqConfig.addDeps((ServiceBuilder<ArquillianConfig>)builder, serviceController);
                    builder.setInitialMode(ServiceController.Mode.ACTIVE);
                    builder.install();
                    break;
                }
                case STARTING: {
                    ServiceName serviceName = serviceController.getName();
                    String simpleName = serviceName.getSimpleName();
                    if (!Services.JBOSS_DEPLOYMENT.isParentOf(serviceName) || !simpleName.equals(Phase.DEPENDENCIES.toString())) break;
                    ServiceName parentName = serviceName.getParent();
                    ServiceController parentController = serviceController.getServiceContainer().getService(parentName);
                    DeploymentUnit depUnit = (DeploymentUnit)parentController.getValue();
                    ArquillianConfigBuilder.handleParseAnnotations(depUnit);
                }
            }
        }
    }

    class ExtendedTestClassLoader
    implements JMXTestRunner.TestClassLoader {
        ExtendedTestClassLoader() {
        }

        public Class<?> loadTestClass(String className) throws ClassNotFoundException {
            ArquillianConfig arqConfig = ArquillianService.this.getArquillianConfig(className, -1L);
            if (arqConfig == null) {
                throw new ClassNotFoundException("No Arquillian config found for: " + className);
            }
            return arqConfig.loadClass(className);
        }
    }

    class ExtendedJMXTestRunner
    extends JMXTestRunner {
        ExtendedJMXTestRunner() {
            super((JMXTestRunner.TestClassLoader)new ExtendedTestClassLoader());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] runTestMethod(String className, String methodName, Map<String, String> protocolProps) {
            ArquillianConfig config = ArquillianService.this.getArquillianConfig(className, 30000L);
            Map<String, Object> properties = Collections.singletonMap(ArquillianService.TEST_CLASS_PROPERTY, className);
            ContextManager contextManager = this.setupContextManager(config, properties);
            try {
                byte[] byArray;
                DeploymentUnit depUnit;
                Module module;
                ClassLoader runWithClassLoader = ClassLoader.getSystemClassLoader();
                if (Boolean.parseBoolean(protocolProps.get("enableThreadContextClassLoader")) && (module = (Module)(depUnit = (DeploymentUnit)config.getDeploymentUnit().getValue()).getAttachment(Attachments.MODULE)) != null) {
                    runWithClassLoader = module.getClassLoader();
                }
                ClassLoader tccl = WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)runWithClassLoader);
                try {
                    byArray = super.runTestMethod(className, methodName, protocolProps);
                }
                catch (Throwable throwable) {
                    WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)tccl);
                    throw throwable;
                }
                WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)tccl);
                return byArray;
            }
            finally {
                if (contextManager != null) {
                    contextManager.teardown(properties);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected TestResult doRunTestMethod(TestRunner runner, Class<?> testClass, String methodName, Map<String, String> protocolProps) {
            ArquillianConfig config;
            DeploymentUnit depUnit;
            Module module;
            ClassLoader runWithClassLoader = ClassLoader.getSystemClassLoader();
            if (Boolean.parseBoolean(protocolProps.get("enableThreadContextClassLoader")) && (module = (Module)(depUnit = (DeploymentUnit)(config = ArquillianService.this.getArquillianConfig(testClass.getName(), 30000L)).getDeploymentUnit().getValue()).getAttachment(Attachments.MODULE)) != null) {
                runWithClassLoader = module.getClassLoader();
            }
            ClassLoader tccl = WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)runWithClassLoader);
            try {
                TestResult testResult = super.doRunTestMethod(runner, testClass, methodName, protocolProps);
                return testResult;
            }
            finally {
                WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)tccl);
            }
        }

        private ContextManager setupContextManager(ArquillianConfig config, Map<String, Object> properties) {
            try {
                DeploymentUnit depUnit = (DeploymentUnit)config.getDeploymentUnit().getValue();
                ContextManagerBuilder builder = new ContextManagerBuilder(config).addAll(depUnit);
                ContextManager contextManager = builder.build();
                contextManager.setup(properties);
                return contextManager;
            }
            catch (Throwable t) {
                return null;
            }
        }
    }
}

