/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.common.aws;

import java.time.Clock;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import org.junit.Assert;

public class AWSUtils {
    public static final long HOUR = 3600000L;
    public static final long TWO_WEEKS = 1209600000L;
    private static DateTimeFormatter STRIPPED_ISO_INSTANT = DateTimeFormatter.ofPattern("yyyyMMdd't'HHmmss'x'SSS'Z'");

    public static String toTimestampedName(Class<?> cl) {
        return AWSUtils.toTimestampedName(cl, Clock.systemUTC());
    }

    static String toTimestampedName(Class<?> cl, Clock clock) {
        return cl.getSimpleName() + "-" + Instant.now(clock).atOffset(ZoneOffset.UTC).format(STRIPPED_ISO_INSTANT);
    }

    public static long toEpochMillis(String name) {
        int lastDash = name.indexOf(45);
        if (lastDash < 0) {
            Assert.fail((String)("Name '" + name + "' should contain a dash"));
        }
        int timeStampStart = name.indexOf(45) + 1;
        TemporalAccessor temporalAccessor = STRIPPED_ISO_INSTANT.parse(name.substring(timeStampStart));
        return LocalDateTime.from(temporalAccessor).atZone(ZoneOffset.UTC).toInstant().toEpochMilli();
    }
}

