/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.common.aws;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClient;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClientBuilder;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBStreamsClient;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBStreamsClientBuilder;
import com.amazonaws.services.dynamodbv2.document.DynamoDB;
import com.amazonaws.services.dynamodbv2.document.Table;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.KeyType;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.ScalarAttributeType;
import com.amazonaws.services.dynamodbv2.model.StreamSpecification;
import com.amazonaws.services.dynamodbv2.model.StreamViewType;
import com.amazonaws.services.dynamodbv2.model.TableDescription;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.builder.ExchangeBuilder;
import org.apache.camel.component.aws.ddb.DdbOperations;
import org.junit.Assert;
import org.wildfly.camel.test.common.aws.AWSUtils;
import org.wildfly.camel.test.common.aws.BasicCredentialsProvider;

public class DynamoDBUtils {
    public static AmazonDynamoDBClient createDynamoDBClient() {
        BasicCredentialsProvider credentials = BasicCredentialsProvider.standard();
        AmazonDynamoDBClient client = !credentials.isValid() ? null : (AmazonDynamoDBClient)((AmazonDynamoDBClientBuilder)((AmazonDynamoDBClientBuilder)AmazonDynamoDBClientBuilder.standard().withCredentials((AWSCredentialsProvider)credentials)).withRegion("eu-west-1")).build();
        return client;
    }

    public static AmazonDynamoDBStreamsClient createDynamoDBStreamsClient() {
        BasicCredentialsProvider credentials = BasicCredentialsProvider.standard();
        AmazonDynamoDBStreamsClient client = !credentials.isValid() ? null : (AmazonDynamoDBStreamsClient)((AmazonDynamoDBStreamsClientBuilder)((AmazonDynamoDBStreamsClientBuilder)AmazonDynamoDBStreamsClientBuilder.standard().withCredentials((AWSCredentialsProvider)credentials)).withRegion("eu-west-1")).build();
        return client;
    }

    public static void putItem(CamelContext camelctx, String title) {
        HashMap<String, AttributeValue> putItem = new HashMap<String, AttributeValue>();
        putItem.put("Id", new AttributeValue().withN("103"));
        putItem.put("Title", new AttributeValue().withS(title));
        Exchange exchange = new ExchangeBuilder(camelctx).withHeader("CamelAwsDdbOperation", (Object)DdbOperations.PutItem).withHeader("CamelAwsDdbItem", putItem).build();
        ProducerTemplate producer = camelctx.createProducerTemplate();
        producer.send("direct:start", exchange);
    }

    public static void updItem(CamelContext camelctx, String title) {
        HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
        key.put("Id", new AttributeValue().withN("103"));
        HashMap<String, AttributeValueUpdate> updItem = new HashMap<String, AttributeValueUpdate>();
        AttributeValueUpdate updValue = new AttributeValueUpdate();
        updValue.setValue(new AttributeValue().withS(title));
        updItem.put("Title", updValue);
        Exchange exchange = new ExchangeBuilder(camelctx).withHeader("CamelAwsDdbOperation", (Object)DdbOperations.UpdateItem).withHeader("CamelAwsDdbKey", key).withHeader("CamelAwsDdbUpdateValues", updItem).build();
        ProducerTemplate producer = camelctx.createProducerTemplate();
        producer.send("direct:start", exchange);
        Assert.assertNull((Object)exchange.getException());
    }

    public static Map<?, ?> getItem(CamelContext camelctx) {
        HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
        key.put("Id", new AttributeValue().withN("103"));
        Exchange exchange = new ExchangeBuilder(camelctx).withHeader("CamelAwsDdbOperation", (Object)DdbOperations.GetItem).withHeader("CamelAwsDdbKey", key).build();
        ProducerTemplate producer = camelctx.createProducerTemplate();
        producer.send("direct:start", exchange);
        Assert.assertNull((Object)exchange.getException());
        return (Map)exchange.getIn().getHeader("CamelAwsDdbAttributes", Map.class);
    }

    public static TableDescription createTable(AmazonDynamoDB client, String tableName) throws InterruptedException {
        CreateTableRequest tableReq = new CreateTableRequest().withTableName(tableName).withKeySchema(new KeySchemaElement[]{new KeySchemaElement("Id", KeyType.HASH)}).withAttributeDefinitions(new AttributeDefinition[]{new AttributeDefinition("Id", ScalarAttributeType.N)}).withProvisionedThroughput(new ProvisionedThroughput(Long.valueOf(10L), Long.valueOf(10L))).withStreamSpecification(new StreamSpecification().withStreamEnabled(Boolean.valueOf(true)).withStreamViewType(StreamViewType.NEW_AND_OLD_IMAGES));
        DynamoDB dynamoDB = new DynamoDB(client);
        Table table = dynamoDB.createTable(tableReq);
        return table.waitForActive();
    }

    public static void deleteTable(AmazonDynamoDB client, String tableName) throws InterruptedException {
        new DynamoDB(client).getTable(tableName).delete();
    }

    public static void assertNoStaleTables(AmazonDynamoDBClient client, String when) {
        List tables = client.listTables().getTableNames().stream().filter(t -> System.currentTimeMillis() - AWSUtils.toEpochMillis(t) > 3600000L || !"DELETING".equals(client.describeTable(t).getTable().getTableStatus())).collect(Collectors.toList());
        Assert.assertEquals((String)String.format("Found stale DynamoDB tables %s running the test: %s", when, tables), (long)0L, (long)tables.size());
    }
}

