/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.common.aws;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.ec2.AmazonEC2Client;
import com.amazonaws.services.ec2.AmazonEC2ClientBuilder;
import com.amazonaws.services.ec2.model.Subnet;
import org.junit.Assert;
import org.wildfly.camel.test.common.aws.BasicCredentialsProvider;

public class EC2Utils {
    public static AmazonEC2Client createEC2Client() {
        BasicCredentialsProvider credentials = BasicCredentialsProvider.standard();
        AmazonEC2Client client = !credentials.isValid() ? null : (AmazonEC2Client)((AmazonEC2ClientBuilder)((AmazonEC2ClientBuilder)AmazonEC2ClientBuilder.standard().withCredentials((AWSCredentialsProvider)credentials)).withRegion("eu-west-1")).build();
        return client;
    }

    public static String getSubnetId(AmazonEC2Client ec2Client) {
        Subnet subnet = null;
        for (Subnet aux : ec2Client.describeSubnets().getSubnets()) {
            System.out.println();
            if (!aux.getState().equals("available") || !aux.getAvailabilityZone().startsWith("eu-west-1")) continue;
            subnet = aux;
            break;
        }
        Assert.assertNotNull((String)"Subnet not null", subnet);
        return subnet.getSubnetId();
    }
}

