/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.common.aws;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.kinesis.AmazonKinesisClient;
import com.amazonaws.services.kinesis.AmazonKinesisClientBuilder;
import com.amazonaws.services.kinesis.model.DescribeStreamRequest;
import com.amazonaws.waiters.NoOpWaiterHandler;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterHandler;
import com.amazonaws.waiters.WaiterParameters;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.wildfly.camel.test.common.aws.BasicCredentialsProvider;

public class KinesisUtils {
    public static AmazonKinesisClient createKinesisClient() {
        BasicCredentialsProvider credentials = BasicCredentialsProvider.standard();
        AmazonKinesisClient client = !credentials.isValid() ? null : (AmazonKinesisClient)((AmazonKinesisClientBuilder)((AmazonKinesisClientBuilder)AmazonKinesisClientBuilder.standard().withCredentials((AWSCredentialsProvider)credentials)).withRegion("eu-west-1")).build();
        return client;
    }

    public static void createStream(AmazonKinesisClient client, String streamName) throws Exception {
        client.createStream(streamName, Integer.valueOf(1));
        Waiter waiter = client.waiters().streamExists();
        DescribeStreamRequest request = new DescribeStreamRequest().withStreamName(streamName);
        Assert.assertNotNull((String)"Cannot obtain stream description", (Object)request);
        Future future = waiter.runAsync(new WaiterParameters((AmazonWebServiceRequest)request), (WaiterHandler)new NoOpWaiterHandler());
        future.get(1L, TimeUnit.MINUTES);
    }
}

