/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.common.aws;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.HeadBucketRequest;
import com.amazonaws.waiters.NoOpWaiterHandler;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterHandler;
import com.amazonaws.waiters.WaiterParameters;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.wildfly.camel.test.common.aws.BasicCredentialsProvider;

public class S3Utils {
    public static AmazonS3Client createS3Client() {
        BasicCredentialsProvider credentials = BasicCredentialsProvider.standard();
        AmazonS3Client client = !credentials.isValid() ? null : (AmazonS3Client)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)credentials)).withRegion("eu-west-1")).build();
        return client;
    }

    public static void createBucket(AmazonS3Client client, String bucketName) throws Exception {
        client.createBucket(bucketName);
        HeadBucketRequest request = new HeadBucketRequest(bucketName);
        Waiter waiter = client.waiters().bucketExists();
        Future future = waiter.runAsync(new WaiterParameters((AmazonWebServiceRequest)request), (WaiterHandler)new NoOpWaiterHandler());
        future.get(1L, TimeUnit.MINUTES);
    }

    public static void deleteBucket(AmazonS3Client client, String bucketName) {
        long deadline = System.currentTimeMillis() + 30000L;
        while (true) {
            try {
                client.deleteBucket(bucketName);
                return;
            }
            catch (AmazonS3Exception amazonS3Exception) {
                try {
                    Thread.sleep(500L);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                if (System.currentTimeMillis() <= deadline) continue;
                return;
            }
            break;
        }
    }
}

