/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.common.aws;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.simpledb.AmazonSimpleDBClient;
import com.amazonaws.services.simpledb.AmazonSimpleDBClientBuilder;
import com.amazonaws.services.simpledb.model.CreateDomainRequest;
import java.util.List;
import org.junit.Assert;
import org.wildfly.camel.test.common.aws.BasicCredentialsProvider;

public class SDBUtils {
    public static AmazonSimpleDBClient createDBClient() {
        BasicCredentialsProvider credentials = BasicCredentialsProvider.standard();
        AmazonSimpleDBClient client = !credentials.isValid() ? null : (AmazonSimpleDBClient)((AmazonSimpleDBClientBuilder)((AmazonSimpleDBClientBuilder)AmazonSimpleDBClientBuilder.standard().withCredentials((AWSCredentialsProvider)credentials)).withRegion("eu-west-1")).build();
        return client;
    }

    public static void createDomain(AmazonSimpleDBClient client, String domainName) throws InterruptedException {
        client.createDomain(new CreateDomainRequest(domainName));
        int retries = 10;
        List domainNames = client.listDomains().getDomainNames();
        while (!domainNames.contains(domainName) && 0 < retries--) {
            Thread.sleep(500L);
            domainNames = client.listDomains().getDomainNames();
        }
        Assert.assertTrue((boolean)domainNames.contains(domainName));
    }
}

