/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.common.aws;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflowClient;
import com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflowClientBuilder;
import com.amazonaws.services.simpleworkflow.model.DomainInfo;
import com.amazonaws.services.simpleworkflow.model.ListDomainsRequest;
import com.amazonaws.services.simpleworkflow.model.RegisterDomainRequest;
import com.amazonaws.services.simpleworkflow.model.TerminateWorkflowExecutionRequest;
import org.wildfly.camel.test.common.aws.BasicCredentialsProvider;

public class SWFUtils {
    public static final String DOMAIN = "wfcdomain";

    public static AmazonSimpleWorkflowClient createWorkflowClient() {
        BasicCredentialsProvider credentials = BasicCredentialsProvider.standard();
        AmazonSimpleWorkflowClient client = !credentials.isValid() ? null : (AmazonSimpleWorkflowClient)((AmazonSimpleWorkflowClientBuilder)((AmazonSimpleWorkflowClientBuilder)AmazonSimpleWorkflowClientBuilder.standard().withCredentials((AWSCredentialsProvider)credentials)).withRegion("eu-west-1")).build();
        return client;
    }

    public static void registerDomain(AmazonSimpleWorkflowClient swfClient) {
        boolean registerDomain = true;
        ListDomainsRequest listreq = new ListDomainsRequest().withRegistrationStatus("REGISTERED");
        for (DomainInfo domain : swfClient.listDomains(listreq).getDomainInfos()) {
            registerDomain &= !DOMAIN.equals(domain.getName());
        }
        if (registerDomain) {
            RegisterDomainRequest domain = new RegisterDomainRequest().withWorkflowExecutionRetentionPeriodInDays("NONE").withName(DOMAIN);
            swfClient.registerDomain(domain);
        }
    }

    public static void terminateWorkflowExecution(AmazonSimpleWorkflowClient swfClient, String workflowId) {
        TerminateWorkflowExecutionRequest terminateReq = new TerminateWorkflowExecutionRequest().withWorkflowId(workflowId).withDomain(DOMAIN);
        swfClient.terminateWorkflowExecution(terminateReq);
    }
}

