/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.common.kafka;

import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer;
import org.apache.kafka.common.utils.SystemTime;
import org.apache.kafka.common.utils.Time;
import org.junit.rules.ExternalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wildfly.camel.test.common.utils.AvailablePortFinder;
import scala.Option;
import scala.collection.JavaConversions;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;

public class EmbeddedKafkaBroker
extends ExternalResource {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final Integer brokerId;
    private final Integer port;
    private final String zkConnection;
    private final Properties baseProperties;
    private final String brokerList;
    private KafkaServer kafkaServer;
    private File logDir;

    public EmbeddedKafkaBroker(int brokerId, String zkConnection) {
        this(brokerId, AvailablePortFinder.getNextAvailable(), zkConnection, new Properties());
    }

    public EmbeddedKafkaBroker(int brokerId, int port, String zkConnection, Properties baseProperties) {
        this.brokerId = brokerId;
        this.port = port;
        this.zkConnection = zkConnection;
        this.baseProperties = baseProperties;
        this.log.info("Starting broker[{}] on port {}", (Object)brokerId, (Object)port);
        this.brokerList = "localhost:" + this.port;
    }

    public void before() {
        this.logDir = Paths.get("target/kafka-log", new String[0]).toFile();
        this.logDir.mkdirs();
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.baseProperties);
        properties.setProperty("zookeeper.connect", this.zkConnection);
        properties.setProperty("broker.id", this.brokerId.toString());
        properties.setProperty("host.name", "localhost");
        properties.setProperty("port", Integer.toString(this.port));
        properties.setProperty("log.dir", this.logDir.getAbsolutePath());
        properties.setProperty("num.partitions", String.valueOf(1));
        properties.setProperty("auto.create.topics.enable", String.valueOf(Boolean.TRUE));
        this.log.info("log directory: " + this.logDir.getAbsolutePath());
        properties.setProperty("log.flush.interval.messages", String.valueOf(1));
        properties.setProperty("offsets.topic.replication.factor", String.valueOf(1));
        this.kafkaServer = this.startBroker(properties);
    }

    public void after() {
        this.kafkaServer.shutdown();
    }

    private KafkaServer startBroker(Properties props) {
        ArrayList kmrList = new ArrayList();
        Buffer metricsList = JavaConversions.asScalaBuffer(kmrList);
        KafkaServer server = new KafkaServer(new KafkaConfig((Map)props), (Time)new SystemTime(), Option.empty(), (Seq)metricsList);
        server.startup();
        return server;
    }

    public String getBrokerList() {
        return this.brokerList;
    }

    public Integer getPort() {
        return this.port;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("EmbeddedKafkaBroker{");
        sb.append("brokerList='").append(this.brokerList).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

