/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.common.rule;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.junit.Assume;
import org.junit.rules.ExternalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wildfly.camel.test.common.utils.EnvironmentUtils;

public class ExecutableResource
extends ExternalResource {
    private static final Path DOWNLOAD_HOME = Paths.get(System.getProperty("user.home"), ".arquillian", "wildfly-camel");
    private static final Logger LOG = LoggerFactory.getLogger(ExecutableResource.class);
    private String executable;
    private String downloadFrom;
    private String args;
    private int waitForPort;
    private boolean managed = true;
    private Process process;

    protected void before() throws Throwable {
        Assume.assumeFalse((String)("Unknown environment: " + EnvironmentUtils.getOSName()), (boolean)EnvironmentUtils.isUnknown());
        this.downloadExecutable();
        if (this.isManaged()) {
            this.startProcess();
        }
    }

    protected void after() {
        if (this.isManaged()) {
            this.stopProcess();
        }
    }

    private void downloadExecutable() throws IOException {
        DOWNLOAD_HOME.toFile().mkdirs();
        File file = DOWNLOAD_HOME.resolve(this.executable).toFile();
        if (!file.exists()) {
            LOG.info("Downloading: {}", (Object)this.downloadFrom);
            URLConnection connection = new URL(this.downloadFrom).openConnection();
            BufferedInputStream in = new BufferedInputStream(connection.getInputStream(), 1024);
            if (this.isZippedResponse(connection.getContentType())) {
                file = DOWNLOAD_HOME.resolve(file.getName() + ".zip").toFile();
                LOG.debug("Downloading compressed archive to: {}", (Object)file.getAbsolutePath());
                this.copyStream(in, new FileOutputStream(file));
                this.unpackArchive(file);
                file.delete();
            } else {
                LOG.debug("Downloading executable to: {}", (Object)file.getAbsolutePath());
                this.copyStream(in, new FileOutputStream(file));
            }
        } else {
            LOG.info("Download skipped (already downloaded) for: {}", (Object)this.downloadFrom);
        }
    }

    public void startProcess() throws Exception {
        File file;
        if (this.executable == "java") {
            file = EnvironmentUtils.getJavaExecutablePath().toFile();
        } else {
            file = DOWNLOAD_HOME.resolve(this.executable).toFile();
            file.setExecutable(true);
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(file.getAbsolutePath());
        command.addAll(Arrays.asList(this.args.split(" ")));
        LOG.info("Starting process: {}", (Object)command.stream().collect(Collectors.joining(" ")));
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.command(command);
        this.process = builder.start();
        boolean socketAvailable = false;
        for (int count = 0; count < 10; ++count) {
            LOG.info("Waiting for process {} on localhost:{} ...", (Object)file.getName(), (Object)this.waitForPort);
            try (Socket socket = new Socket("localhost", this.waitForPort);){
                if (socket.isConnected()) {
                    LOG.info("Successfully connected to localhost:{}", (Object)this.waitForPort);
                    socketAvailable = true;
                    break;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Thread.sleep(1000L);
        }
        if (!socketAvailable) {
            this.stopProcess();
            throw new IllegalStateException("Failed to connect to external resource at localhost:" + this.waitForPort);
        }
    }

    public void stopProcess() {
        if (this.process != null) {
            LOG.info("Terminating process");
            this.process.destroy();
            int count = 0;
            while (this.process.isAlive()) {
                LOG.info("Process is still running. Waiting for exit...");
                if (count == 10) {
                    LOG.info("Gave up waiting for process to exit. Forcibly terminating!");
                    this.process.destroyForcibly();
                    return;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++count;
            }
        }
    }

    private boolean isZippedResponse(String contentType) {
        return contentType.equals("application/zip") || contentType.equals("application/octet-stream");
    }

    private void unpackArchive(File file) throws IOException {
        ZipFile zipFile = new ZipFile(file);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            LOG.debug("Extracting archive entry: {}", (Object)entry.getName());
            File zipFileEntry = DOWNLOAD_HOME.resolve(entry.getName()).toFile();
            if (!entry.isDirectory()) {
                this.copyStream(zipFile.getInputStream(entry), new FileOutputStream(zipFileEntry));
                continue;
            }
            zipFileEntry.mkdirs();
        }
        zipFile.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        try {
            byte[] buffer = new byte[1024];
            int len = inputStream.read(buffer);
            while (len >= 0) {
                outputStream.write(buffer, 0, len);
                len = inputStream.read(buffer);
            }
        }
        finally {
            inputStream.close();
            outputStream.flush();
            outputStream.close();
        }
    }

    public ExecutableResourceBuilder builder() {
        return new ExecutableResourceBuilder();
    }

    public String getDownloadFrom() {
        return this.downloadFrom;
    }

    public void setDownloadFrom(String downloadFrom) {
        this.downloadFrom = downloadFrom;
    }

    public String getArgs() {
        return this.args;
    }

    public void setArgs(String args) {
        this.args = args;
    }

    public int getWaitForPort() {
        return this.waitForPort;
    }

    public void setWaitForPort(int waitForPort) {
        this.waitForPort = waitForPort;
    }

    public String getExecutable() {
        return this.executable;
    }

    public void setExecutable(String executable) {
        this.executable = executable;
    }

    public boolean isManaged() {
        return this.managed;
    }

    public void setManaged(boolean managed) {
        this.managed = managed;
    }

    public class ExecutableResourceBuilder {
        private String executable;
        private String downloadFrom;
        private String args;
        private int waitForPort;
        private boolean managed;

        public ExecutableResourceBuilder executable(String executable) {
            String fileSuffix = "";
            if (EnvironmentUtils.isWindows() && !executable.endsWith(".exe")) {
                fileSuffix = ".exe";
            }
            this.executable = executable + fileSuffix;
            return this;
        }

        public ExecutableResourceBuilder downloadFrom(String downloadFrom) {
            this.downloadFrom = downloadFrom;
            return this;
        }

        public ExecutableResourceBuilder args(String args) {
            this.args = args;
            return this;
        }

        public ExecutableResourceBuilder waitForPort(int waitForPort) {
            this.waitForPort = waitForPort;
            return this;
        }

        public ExecutableResourceBuilder managed(boolean managed) {
            this.managed = managed;
            return this;
        }

        public ExecutableResource build() {
            ExecutableResource resource = new ExecutableResource();
            resource.setExecutable(this.executable);
            resource.setDownloadFrom(this.downloadFrom);
            resource.setArgs(this.args);
            resource.setWaitForPort(this.waitForPort);
            resource.setManaged(this.managed);
            return resource;
        }
    }
}

