/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.common.ssh;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Arrays;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.command.Command;
import org.apache.sshd.server.command.CommandFactory;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.apache.sshd.server.scp.ScpCommandFactory;
import org.apache.sshd.server.shell.ProcessShellFactory;
import org.apache.sshd.server.subsystem.sftp.SftpSubsystemFactory;
import org.wildfly.camel.test.common.utils.AvailablePortFinder;
import org.wildfly.camel.test.common.utils.EnvironmentUtils;

public class EmbeddedSSHServer {
    private SshServer sshServer = SshServer.setUpDefaultServer();
    private Path homeDir;

    public EmbeddedSSHServer(Path homeDir) {
        this(homeDir, AvailablePortFinder.getNextAvailable());
    }

    public EmbeddedSSHServer(Path homeDir, int port) {
        this.sshServer.setPort(port);
        this.sshServer.setCommandFactory((CommandFactory)new EchoCommandFactory());
        this.sshServer.setKeyPairProvider((KeyPairProvider)new SimpleGeneratorHostKeyProvider());
        this.sshServer.setPasswordAuthenticator((username, password, serverSession) -> username.equals("admin") && password.equals("admin"));
        this.sshServer.setPublickeyAuthenticator((s, publicKey, serverSession) -> true);
        this.homeDir = homeDir;
        if (EnvironmentUtils.isWindows()) {
            this.sshServer.setShellFactory((Factory)new ProcessShellFactory(new String[]{"cmd.exe "}));
        } else {
            this.sshServer.setShellFactory((Factory)new ProcessShellFactory(new String[]{"/bin/sh", "-i", "-s"}));
        }
    }

    public void setupSftp() {
        this.sshServer.setCommandFactory((CommandFactory)new ScpCommandFactory());
        this.sshServer.setSubsystemFactories(Arrays.asList(new SftpSubsystemFactory()));
    }

    public void start() throws Exception {
        this.sshServer.start();
        this.setupKnownHosts();
    }

    public void stop() throws Exception {
        this.sshServer.stop();
    }

    public String getConnection() {
        return String.format("localhost:%d", this.sshServer.getPort());
    }

    private void setupKnownHosts() {
        File knownHostsFile = this.homeDir.resolve("known_hosts").toFile();
        JSch jsch = new JSch();
        try {
            this.homeDir.toFile().mkdirs();
            knownHostsFile.createNewFile();
            jsch.setKnownHosts(knownHostsFile.getPath());
            Session s = jsch.getSession("admin", "localhost", this.sshServer.getPort());
            s.setConfig("StrictHostKeyChecking", "ask");
            s.setConfig("HashKnownHosts", "no");
            s.setUserInfo(new UserInfo(){

                public String getPassphrase() {
                    return null;
                }

                public String getPassword() {
                    return "admin";
                }

                public boolean promptPassword(String message) {
                    return true;
                }

                public boolean promptPassphrase(String message) {
                    return false;
                }

                public boolean promptYesNo(String message) {
                    return true;
                }

                public void showMessage(String message) {
                }
            });
            s.connect();
            s.disconnect();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to configure known_hosts file", e);
        }
    }

    private static final class EchoCommand
    implements Command,
    Runnable {
        private String command;
        private OutputStream out;
        private ExitCallback callback;
        private Thread thread;

        public EchoCommand(String command) {
            this.command = command;
        }

        public void setInputStream(InputStream in) {
        }

        public void setOutputStream(OutputStream out) {
            this.out = out;
        }

        public void setErrorStream(OutputStream err) {
        }

        public void setExitCallback(ExitCallback callback) {
            this.callback = callback;
        }

        public void start(Environment env) throws IOException {
            this.thread = new Thread((Runnable)this, "EchoCommand");
            this.thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean success = true;
            String message = null;
            try {
                String fakeCommand = "Running command: " + this.command;
                this.out.write(fakeCommand.getBytes());
                this.out.flush();
            }
            catch (Exception e) {
                success = false;
                message = e.toString();
            }
            finally {
                if (success) {
                    this.callback.onExit(0);
                } else {
                    this.callback.onExit(1, message);
                }
            }
        }

        public void destroy() throws Exception {
            this.thread.interrupt();
        }
    }

    private static final class EchoCommandFactory
    implements CommandFactory {
        private EchoCommandFactory() {
        }

        public Command createCommand(String command) {
            return new EchoCommand(command);
        }
    }
}

