/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.common.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.wildfly.camel.utils.IllegalStateAssertion;

public final class AvailablePortFinder {
    public static final int MIN_PORT_NUMBER = 1100;
    public static final int MAX_PORT_NUMBER = 65535;
    private static Set<Integer> alreadyUsed = new HashSet<Integer>();

    public static int getNextAvailable() {
        return AvailablePortFinder.getNextAvailable(1100);
    }

    public static int getNextAvailable(int fromPort) {
        InetAddress addr;
        try {
            addr = InetAddress.getLocalHost();
        }
        catch (UnknownHostException ex) {
            throw new IllegalStateException(ex);
        }
        return AvailablePortFinder.getNextAvailable(addr, fromPort);
    }

    public static int getNextAvailable(InetAddress addr) {
        return AvailablePortFinder.getNextAvailable(addr, 1100);
    }

    public static int getNextAvailable(InetAddress addr, int fromPort) {
        if (fromPort < 1100 || fromPort > 65535) {
            throw new IllegalArgumentException("Invalid start port: " + fromPort);
        }
        for (int i = fromPort; i <= 65535; ++i) {
            if (!AvailablePortFinder.available(addr, i)) continue;
            return i;
        }
        throw new NoSuchElementException("Could not find an available port above " + fromPort);
    }

    public static int getAndStoreNextAvailable(String filename) {
        int port = AvailablePortFinder.getNextAvailable();
        AvailablePortFinder.storeServerData(filename, port);
        return port;
    }

    public static synchronized boolean available(InetAddress addr, int port) {
        try (ServerSocket ss = new ServerSocket();){
            ss.setReuseAddress(false);
            ss.bind(new InetSocketAddress(addr, port));
        }
        catch (IOException e) {
            return false;
        }
        return alreadyUsed.add(port);
    }

    public static Path storeServerData(String filename, Object port) {
        Path filePath = AvailablePortFinder.getDataDirPath().resolve(filename);
        try (PrintWriter fw = new PrintWriter(new FileWriter(filePath.toFile()));){
            fw.println("" + port);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        return filePath;
    }

    public static String readServerData(String filename) {
        Path filePath = AvailablePortFinder.getDataDirPath().resolve(filename);
        String result = null;
        try (BufferedReader fw = new BufferedReader(new FileReader(filePath.toFile()));){
            result = fw.readLine().trim();
        }
        catch (FileNotFoundException ex) {
            return null;
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
        return result;
    }

    public static Future<String> readServerDataAsync(final String filename) {
        Future<String> future = new Future<String>(){
            private String result;
            private boolean cancelled;

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                this.cancelled = true;
                return true;
            }

            @Override
            public boolean isCancelled() {
                return this.cancelled;
            }

            @Override
            public boolean isDone() {
                return this.cancelled || this.result != null;
            }

            @Override
            public String get() throws InterruptedException, ExecutionException {
                if (this.result != null) {
                    return this.result;
                }
                this.result = AvailablePortFinder.readServerData(filename);
                return this.result;
            }

            @Override
            public String get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                this.result = AvailablePortFinder.readServerData(filename);
                if (this.result != null) {
                    return this.result;
                }
                long endTime = System.currentTimeMillis() + unit.toMillis(timeout);
                while (!this.cancelled && this.result == null && System.currentTimeMillis() < endTime) {
                    Thread.sleep(100L);
                    this.result = AvailablePortFinder.readServerData(filename);
                }
                if (this.result != null) {
                    return this.result;
                }
                throw new TimeoutException();
            }
        };
        return future;
    }

    public static void removeServerData(String filename) {
        File dataFile = AvailablePortFinder.getDataDirPath().resolve(filename).toFile();
        try {
            if (dataFile.exists()) {
                dataFile.delete();
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static Path getDataDirPath() {
        String jbossHome = System.getProperty("jboss.home.dir");
        IllegalStateAssertion.assertNotNull((Object)jbossHome, (String)"Property 'jboss.home.dir' not set");
        IllegalStateAssertion.assertTrue((Boolean)new File(jbossHome).isDirectory(), (String)("Not a directory: " + jbossHome));
        Path dirPath = Paths.get(jbossHome, "standalone", "data");
        return dirPath;
    }
}

