/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.common.utils;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.dmr.ModelNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMRUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DMRUtils.class);
    private static Pattern HANDLER_PATTERN = Pattern.compile(".*handler=(.*)");

    public static ModelNode createOpNode(String address, String operation) {
        Matcher matcher;
        ModelNode op = new ModelNode();
        ModelNode list = op.get("address").setEmptyList();
        if (address != null) {
            String[] pathSegments;
            for (String segment : pathSegments = address.split("/")) {
                String[] elements = segment.split("=");
                list.add(elements[0], elements[1]);
            }
        }
        if ((matcher = Pattern.compile(".*\\((.*?)\\)").matcher(operation)).matches()) {
            matcher.reset();
            op.get("operation").set(operation.substring(0, operation.indexOf(40)));
            while (matcher.find()) {
                String args = matcher.group(1);
                if (args.matches(".*\\{.*\\}.*")) {
                    ModelNode node = new ModelNode();
                    String[] argElements = args.split("(?!=>)=");
                    for (String argSegment : argElements[1].replaceAll("[{}]", "").split(",")) {
                        String[] argParams = argSegment.split("=>");
                        node.get(argParams[0]).set(argParams[1]);
                    }
                    op.get(argElements[0].trim()).set(node);
                    continue;
                }
                for (String argSegment : args.replaceAll("[{}\\[\\]]", "").split(",")) {
                    if (argSegment.startsWith("handlers")) {
                        Matcher handlerMatch = HANDLER_PATTERN.matcher(argSegment);
                        if (!handlerMatch.find()) continue;
                        op.get("handlers").add(handlerMatch.group(1));
                        continue;
                    }
                    String[] argElements = argSegment.split("(?!=>)=");
                    String nodeName = argElements[0].trim();
                    if (argElements.length > 2) {
                        op.get(nodeName).set(argSegment.replace(nodeName + "=", ""));
                        continue;
                    }
                    if (nodeName.equals("handlers")) {
                        op.add(argElements[1].trim());
                        continue;
                    }
                    op.get(nodeName).set(argElements[1].trim());
                }
            }
        } else {
            op.get("operation").set(operation);
        }
        return op;
    }

    public static ModelNode createCompositeNode(ModelNode[] steps) {
        ModelNode comp = new ModelNode();
        comp.get("operation").set("composite");
        for (ModelNode step : steps) {
            comp.get("steps").add(step);
        }
        return comp;
    }

    public static BatchNodeBuilder batchNode() {
        return new BatchNodeBuilder();
    }

    public static ExecutionResult executeOperation(ModelControllerClient client, ModelNode operationNode) throws IOException {
        ModelNode result = client.execute(new OperationBuilder(operationNode).build());
        return new ExecutionResult(result);
    }

    public static class ExecutionResult {
        private final ModelNode wrappedResult;

        ExecutionResult(ModelNode wrappedResult) {
            this.wrappedResult = wrappedResult;
        }

        public ExecutionResult assertSuccess() {
            if (this.wrappedResult.hasDefined("outcome") && "success".equals(this.wrappedResult.get("outcome").asString())) {
                if (this.wrappedResult.hasDefined("result")) {
                    LOG.trace(this.wrappedResult.get("result").toString());
                }
            } else {
                if (this.wrappedResult.hasDefined("failure-description")) {
                    throw new RuntimeException(this.wrappedResult.get("failure-description").toString());
                }
                throw new RuntimeException("Operation not successful; outcome = " + this.wrappedResult.get("outcome"));
            }
            return this;
        }

        public ModelNode getWrappedResult() {
            return this.wrappedResult;
        }

        public ModelNode getUnwrappedResult() {
            if (this.wrappedResult.hasDefined("result")) {
                return this.wrappedResult.get("result");
            }
            return null;
        }
    }

    public static final class BatchNodeBuilder {
        private ModelNode batchNode = new ModelNode();

        BatchNodeBuilder() {
            this.batchNode.get("operation").set("composite");
            this.batchNode.get("address").setEmptyList();
        }

        public BatchNodeBuilder addStep(String address, String operation) {
            this.batchNode.get("steps").add(DMRUtils.createOpNode(address, operation));
            return this;
        }

        public BatchNodeBuilder addStep(ModelNode operation) {
            this.batchNode.get("steps").add(operation);
            return this;
        }

        public ExecutionResult execute(ModelControllerClient client) throws IOException {
            return DMRUtils.executeOperation(client, this.build());
        }

        public ModelNode build() {
            return this.batchNode;
        }
    }
}

