/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.common.utils;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;

public final class EnvironmentUtils {
    private static final boolean AIX;
    private static final boolean LINUX;
    private static final boolean MAC;
    private static final boolean WINDOWS;
    private static final boolean VM_IBM_JDK;
    private static final boolean VM_OPEN_JDK;
    private static final String JAVA;
    private static final Path JAVA_HOME;
    private static final Path WILDFLY_HOME;

    public static String getOSName() {
        return System.getProperty("os.name").toLowerCase(Locale.ROOT);
    }

    private EnvironmentUtils() {
    }

    public static boolean isAIX() {
        return AIX;
    }

    public static boolean isLinux() {
        return LINUX;
    }

    public static boolean isMac() {
        return MAC;
    }

    public static boolean isWindows() {
        return WINDOWS;
    }

    public static boolean isUnknown() {
        return !AIX && !LINUX && !MAC && !WINDOWS;
    }

    public static boolean isIbmJDK() {
        return VM_IBM_JDK;
    }

    public static boolean isOpenJDK() {
        return VM_OPEN_JDK;
    }

    public static Path getJavaExecutablePath() {
        return Paths.get(JAVA_HOME.toString(), "bin", JAVA);
    }

    public static Path getWildFlyHome() {
        return WILDFLY_HOME;
    }

    static {
        String os = EnvironmentUtils.getOSName();
        AIX = os.equals("aix");
        LINUX = os.equals("linux");
        MAC = os.startsWith("mac");
        WINDOWS = os.contains("win");
        VM_IBM_JDK = System.getProperty("java.vm.name").startsWith("IBM");
        VM_OPEN_JDK = System.getProperty("java.vm.name").startsWith("OpenJDK");
        String javaExecutable = "java";
        if (WINDOWS) {
            javaExecutable = "java.exe";
        }
        JAVA = javaExecutable;
        String javaHome = System.getenv("JAVA_HOME");
        if (javaHome == null) {
            javaHome = System.getProperty("java.home");
        }
        JAVA_HOME = Paths.get(javaHome, new String[0]);
        WILDFLY_HOME = Paths.get(System.getProperty("jboss.home.dir"), new String[0]);
    }
}

