/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.common.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Random;

public final class FileUtils {
    private static final Random RANDOM = new Random();

    private FileUtils() {
    }

    public static File constructTempDir(String dirPrefix) {
        File file = new File(System.getProperty("java.io.tmpdir"), dirPrefix + RANDOM.nextInt(10000000));
        if (!file.mkdirs()) {
            throw new RuntimeException("could not create temp directory: " + file.getAbsolutePath());
        }
        file.deleteOnExit();
        return file;
    }

    public static void deleteDirectory(Path dirPath) throws IOException {
        if (dirPath.toFile().isDirectory()) {
            Files.walkFileTree(dirPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exception) throws IOException {
                    exception.printStackTrace();
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exception) throws IOException {
                    if (exception == null) {
                        Files.delete(dir);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    public static boolean deleteFile(File path) throws FileNotFoundException {
        if (!path.exists()) {
            throw new FileNotFoundException(path.getAbsolutePath());
        }
        boolean ret = true;
        if (path.isDirectory()) {
            for (File f : path.listFiles()) {
                ret = ret && FileUtils.deleteFile(f);
            }
        }
        return ret && path.delete();
    }

    public static void copy(URL src, Path destination) throws IOException {
        try (InputStream in = src.openStream();
             OutputStream out = Files.newOutputStream(destination, new OpenOption[0]);){
            int len;
            byte[] buffer = new byte[1024];
            while ((len = in.read(buffer)) >= 0) {
                out.write(buffer, 0, len);
            }
        }
    }

    public static void copy(URL src, Appendable out) throws IOException {
        try (InputStreamReader in = new InputStreamReader(src.openStream(), StandardCharsets.UTF_8);){
            int len;
            char[] buffer = new char[1024];
            while ((len = in.read(buffer)) >= 0) {
                out.append(new String(buffer, 0, len));
            }
        }
    }
}

