/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.common.utils;

import java.io.IOException;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.wildfly.camel.utils.IllegalStateAssertion;

public class JMSUtils {
    public static ModelNode createJmsQueue(String queueName, String jndiName, ModelControllerClient client) throws IOException {
        ModelNode modelNode = JMSUtils.createJmsQueueModelNode("add", queueName, jndiName, client);
        ModelNode result = JMSUtils.executeModelNode(client, modelNode);
        System.out.println("JMS queue added: " + jndiName);
        return result;
    }

    public static ModelNode removeJmsQueue(String queueName, ModelControllerClient client) throws IOException {
        ModelNode modelNode = JMSUtils.createJmsQueueModelNode("remove", queueName, null, client);
        ModelNode result = JMSUtils.executeModelNode(client, modelNode);
        System.out.println("JMS queue removed: " + queueName);
        return result;
    }

    private static ModelNode executeModelNode(ModelControllerClient client, ModelNode modelNode) throws IOException {
        ModelNode result = client.execute(modelNode);
        String outcome = result.get("outcome").asString();
        IllegalStateAssertion.assertEquals((Object)"success", (Object)outcome, (String)("Unexpected outcome: " + modelNode));
        return result;
    }

    private static ModelNode createJmsQueueModelNode(String operationName, String queueName, String jndiName, ModelControllerClient client) {
        ModelNode modelNode = new ModelNode();
        modelNode.get("operation").set(operationName);
        modelNode.get("address").add("subsystem", MessagingSubsystem.ACTIVEMQ_ARTEMIS.getSubsystemName());
        modelNode.get("address").add(MessagingSubsystem.ACTIVEMQ_ARTEMIS.getServerName(), "default");
        modelNode.get("address").add("jms-queue", queueName);
        if (jndiName != null) {
            modelNode.get("entries").add(jndiName);
        }
        return modelNode;
    }

    private static enum MessagingSubsystem {
        ACTIVEMQ_ARTEMIS("messaging-activemq", "server");

        private final String subsystemName;
        private final String serverName;

        private MessagingSubsystem(String subsystemName, String serverName) {
            this.subsystemName = subsystemName;
            this.serverName = serverName;
        }

        public String getSubsystemName() {
            return this.subsystemName;
        }

        public String getServerName() {
            return this.serverName;
        }
    }
}

