/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.common.utils;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;

public class LogUtils {
    private static final Path SERVER_LOG = Paths.get(System.getProperty("jboss.server.log.dir"), new String[0]).resolve("server.log");

    public static boolean awaitLogMessage(String message, long timeout) {
        return LogUtils.awaitLogMessage(message, timeout, SERVER_LOG);
    }

    public static boolean awaitLogMessage(String message, long timeout, Path logFilePath) {
        long start = System.currentTimeMillis();
        do {
            try {
                List<String> logLines = Files.readAllLines(logFilePath);
                if (logLines.stream().filter(line -> line.matches(message)).count() > 0L) {
                    return true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        } while (System.currentTimeMillis() - start < timeout);
        return false;
    }
}

