/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.common.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ManifestBuilder {
    public static final Logger LOGGER = LoggerFactory.getLogger(ManifestBuilder.class);
    private List<String> lines = new ArrayList<String>();
    private Manifest manifest;

    public ManifestBuilder() {
        this("1.0");
    }

    public ManifestBuilder(String manifestVersion) {
        if (manifestVersion != null) {
            this.append(Attributes.Name.MANIFEST_VERSION + ": " + manifestVersion);
        }
    }

    public ManifestBuilder addManifestHeader(String key, String value) {
        this.append(key + ": " + value);
        return this;
    }

    public Manifest getManifest() {
        if (this.manifest == null) {
            StringWriter out = new StringWriter();
            PrintWriter pw = new PrintWriter(out);
            for (String line : this.lines) {
                byte[] bytes = line.getBytes();
                while (bytes.length >= 512) {
                    byte[] head = Arrays.copyOf(bytes, 256);
                    bytes = Arrays.copyOfRange(bytes, 256, bytes.length);
                    pw.println(new String(head));
                    pw.print(" ");
                }
                pw.println(new String(bytes));
            }
            String content = out.toString();
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(content);
            }
            try {
                this.manifest = new Manifest(new ByteArrayInputStream(content.getBytes()));
            }
            catch (IOException ex) {
                throw new IllegalStateException("Cannot create manifest", ex);
            }
        }
        return this.manifest;
    }

    public InputStream openStream() {
        Manifest manifest = this.getManifest();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            manifest.write(baos);
            return new ByteArrayInputStream(baos.toByteArray());
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot provide manifest input stream", ex);
        }
    }

    public void append(String line) {
        if (this.manifest != null) {
            throw new IllegalStateException("Cannot append to existing manifest");
        }
        this.lines.add(line);
    }

    public static enum Type {
        String,
        Version,
        VersionRange,
        Long,
        Double;

    }
}

