/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.common.utils;

import org.apache.camel.CamelContext;
import org.apache.camel.spring.SpringCamelContext;
import org.springframework.context.ApplicationContext;
import org.wildfly.camel.utils.IllegalArgumentAssertion;
import org.wildfly.camel.utils.IllegalStateAssertion;

public final class SpringUtils {
    private SpringUtils() {
    }

    public static ApplicationContext getApplicationContext(CamelContext camelctx) {
        IllegalArgumentAssertion.assertTrue((Boolean)(camelctx instanceof SpringCamelContext), (String)("Not an SpringCamelContext: " + camelctx));
        return ((SpringCamelContext)camelctx).getApplicationContext();
    }

    public static <T> T getMandatoryBean(CamelContext camelctx, Class<T> type, String name) {
        Object value = SpringUtils.getApplicationContext(camelctx).getBean(name);
        IllegalStateAssertion.assertNotNull((Object)value, (String)("No spring bean found for name <" + name + ">"));
        IllegalStateAssertion.assertTrue((Boolean)type.isInstance(value), (String)("Bean is not of type <" + type.getName() + ">"));
        return type.cast(value);
    }
}

