/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.common.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URI;
import org.jboss.modules.ModuleClassLoader;
import org.wildfly.camel.utils.IOUtils;
import org.wildfly.camel.utils.IllegalStateAssertion;

public final class TestUtils {
    private TestUtils() {
    }

    public static String getDockerHost() throws Exception {
        String dockerHost = System.getenv("DOCKER_HOST");
        if (dockerHost == null) {
            InetAddress localHost = InetAddress.getLocalHost();
            return localHost.getHostAddress();
        }
        URI uri = new URI(dockerHost);
        return uri.getHost();
    }

    public static Integer getDockerPort() throws Exception {
        String dockerHost = System.getenv("DOCKER_HOST");
        if (dockerHost == null) {
            return 2376;
        }
        URI uri = new URI(dockerHost);
        return uri.getPort();
    }

    public static String getResourceValue(Class<?> clazz, String resname) throws IOException {
        try (InputStream in = clazz.getResourceAsStream(resname);){
            IllegalStateAssertion.assertNotNull((Object)in, (String)("Cannot find resource: " + resname));
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            IOUtils.copyStream((InputStream)in, (OutputStream)out);
            String string = new String(out.toByteArray());
            return string;
        }
    }

    public static String getClassLoaderModuleName(ClassLoader classLoader) {
        if (classLoader instanceof ModuleClassLoader) {
            ModuleClassLoader moduleClassLoader = (ModuleClassLoader)classLoader;
            return moduleClassLoader.getModule().getName();
        }
        throw new IllegalArgumentException("ClassLoader must be of type ModuleClassLoader");
    }
}

