/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.common.utils;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.wildfly.camel.test.common.utils.EnvironmentUtils;

public final class UserManager
implements Closeable {
    private static final String APPLICATION_REALM = "ApplicationRealm";
    private static final String MANAGEMENT_REALM = "ManagementRealm";
    private static final char[] HEX_CHARS = "0123456789abcdef".toCharArray();
    private final String realm;
    private Properties roleProperties;
    private final Path rolePropertiesPath;
    private Properties userProperties;
    private final Path userPropertiesPath;

    public UserManager(Path userPropertiesPath, Path rolePropertiesPath, String realm) throws IOException {
        Throwable throwable;
        InputStream in;
        this.userPropertiesPath = userPropertiesPath;
        this.rolePropertiesPath = rolePropertiesPath;
        this.realm = realm;
        this.userProperties = new Properties();
        if (Files.exists(userPropertiesPath, new LinkOption[0])) {
            in = Files.newInputStream(userPropertiesPath, new OpenOption[0]);
            throwable = null;
            try {
                this.userProperties.load(in);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (in != null) {
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        in.close();
                    }
                }
            }
        }
        this.roleProperties = new Properties();
        if (Files.exists(rolePropertiesPath, new LinkOption[0])) {
            in = Files.newInputStream(rolePropertiesPath, new OpenOption[0]);
            throwable = null;
            try {
                this.roleProperties.load(in);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (in != null) {
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        in.close();
                    }
                }
            }
        }
    }

    public static UserManager forStandaloneApplicationRealm() throws IOException {
        return UserManager.forStandaloneApplicationRealm(EnvironmentUtils.getWildFlyHome());
    }

    public static UserManager forStandaloneApplicationRealm(Path jbossHome) throws IOException {
        Path userPropertiesPath = jbossHome.resolve("standalone/configuration/application-users.properties");
        Path rolePropertiesPath = jbossHome.resolve("standalone/configuration/application-roles.properties");
        return new UserManager(userPropertiesPath, rolePropertiesPath, APPLICATION_REALM);
    }

    public static UserManager forStandaloneManagementRealm() throws IOException {
        return UserManager.forStandaloneManagementRealm(EnvironmentUtils.getWildFlyHome());
    }

    public static UserManager forStandaloneManagementRealm(Path jbossHome) throws IOException {
        Path userPropertiesPath = jbossHome.resolve("standalone/configuration/mgmt-users.properties");
        Path rolePropertiesPath = jbossHome.resolve("standalone/configuration/mgmt-roles.properties");
        return new UserManager(userPropertiesPath, rolePropertiesPath, MANAGEMENT_REALM);
    }

    public static UserManager forStandaloneCustomRealm(String userPropertiesFileName, String rolesPropertiesFileName, String realmName) throws IOException {
        Path jbossHome = EnvironmentUtils.getWildFlyHome();
        Path userPropertiesPath = jbossHome.resolve("standalone/configuration/" + userPropertiesFileName);
        Path rolePropertiesPath = jbossHome.resolve("standalone/configuration/" + rolesPropertiesFileName);
        return new UserManager(userPropertiesPath, rolePropertiesPath, realmName);
    }

    public UserManager addRole(String userName, String role) {
        List roles = Optional.ofNullable(this.roleProperties.getProperty(userName)).map(list -> new ArrayList<String>(Arrays.asList(list.split(",")))).orElse(new ArrayList());
        roles.add(role);
        this.roleProperties.put(userName, roles.stream().collect(Collectors.joining(",")));
        return this;
    }

    public UserManager addUser(String userName, String password) {
        this.userProperties.put(userName, UserManager.encryptPassword(userName, password, this.realm));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() throws IOException {
        Throwable throwable;
        OutputStream out;
        try {
            out = Files.newOutputStream(this.userPropertiesPath, new OpenOption[0]);
            throwable = null;
            try {
                this.userProperties.store(out, null);
                return;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        finally {
            this.userProperties = null;
            try {
                out = Files.newOutputStream(this.rolePropertiesPath, new OpenOption[0]);
                throwable = null;
                try {
                    this.roleProperties.store(out, null);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (out != null) {
                        if (throwable != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            out.close();
                        }
                    }
                }
            }
            finally {
                this.roleProperties = null;
            }
        }
    }

    public UserManager removeRole(String userName, String role) {
        List roles = Optional.ofNullable(this.roleProperties.getProperty(userName)).map(list -> new ArrayList<String>(Arrays.asList(list.split(",")))).orElse(new ArrayList());
        roles.remove(role);
        if (roles.isEmpty()) {
            this.roleProperties.remove(userName);
        } else {
            this.roleProperties.put(userName, roles.stream().collect(Collectors.joining(",")));
        }
        return this;
    }

    public UserManager removeUser(String userName) {
        this.userProperties.remove(userName);
        return this;
    }

    private static String encryptPassword(String userName, String password, String realm) {
        try {
            String stringToEncrypt = String.format("%s:%s:%s", userName, realm, password);
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] hashedPassword = md.digest(stringToEncrypt.getBytes(StandardCharsets.UTF_8));
            char[] converted = new char[hashedPassword.length * 2];
            for (int i = 0; i < hashedPassword.length; ++i) {
                byte b = hashedPassword[i];
                converted[i * 2] = HEX_CHARS[b >> 4 & 0xF];
                converted[i * 2 + 1] = HEX_CHARS[b & 0xF];
            }
            return String.valueOf(converted);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }
}

