/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.common.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.wildfly.camel.test.common.utils.EnvironmentUtils;
import org.wildfly.camel.test.common.utils.FileUtils;

public class WildFlyCli {
    private static final String DEFAULT_TIMEOUT = "60000";
    private final Path wildFlyHome;

    public WildFlyCli(Path wildFlyHome) {
        this.wildFlyHome = wildFlyHome;
    }

    public WildFlyCli() {
        this(EnvironmentUtils.getWildFlyHome());
    }

    public WildFlyCliResult run(Path cliScript, String ... cliArgs) throws IOException, InterruptedException {
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        String ext = EnvironmentUtils.isWindows() ? "bat" : "sh";
        String jbossCliPath = this.wildFlyHome.resolve("bin/jboss-cli." + ext).normalize().toString();
        ArrayList<String> command = new ArrayList<String>();
        command.add(jbossCliPath);
        command.add("--connect");
        command.add("--echo-command");
        command.add("--file=" + cliScript.normalize().toString());
        command.addAll(Arrays.asList(cliArgs));
        if (!command.stream().anyMatch(arg -> arg.startsWith("--timeout"))) {
            command.add("--timeout=60000");
        }
        pb.command(command);
        pb.environment().put("NOPAUSE", "Y");
        Process process = pb.start();
        StreamGobbler stdOut = new StreamGobbler(process.getInputStream());
        stdOut.start();
        StreamGobbler stdErr = new StreamGobbler(process.getErrorStream());
        stdErr.start();
        int exitCode = process.waitFor();
        stdOut.join();
        stdErr.join();
        return new WildFlyCliResult(command, exitCode, stdOut.getString(), stdErr.getString());
    }

    public WildFlyCliResult run(String cliScript, String ... cliArgs) throws IOException, InterruptedException {
        Path path = Files.createTempFile(WildFlyCli.class.getSimpleName(), ".cli", new FileAttribute[0]);
        Files.write(path, cliScript.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        return this.run(path, cliArgs);
    }

    public WildFlyCliResult run(URL cliScript, String ... cliArgs) throws IOException, InterruptedException {
        Path path = Files.createTempFile(WildFlyCli.class.getSimpleName(), ".cli", new FileAttribute[0]);
        FileUtils.copy(cliScript, path);
        return this.run(path, cliArgs);
    }

    public static class WildFlyCliResult {
        private final List<String> command;
        private final int exitValue;
        private final String stdErr;
        private final String stdOut;

        WildFlyCliResult(List<String> command, int exitValue, String stdOut, String stdErr) {
            this.command = command;
            this.exitValue = exitValue;
            this.stdOut = stdOut;
            this.stdErr = stdErr;
        }

        public WildFlyCliResult assertSuccess() {
            if (this.exitValue != 0) {
                throw new RuntimeException(String.format("Command %s returned %d.\n\nstdout: %s\n\nstdErr: %s", String.join((CharSequence)",", this.command), this.exitValue, this.stdOut, this.stdErr));
            }
            if (!this.stdErr.isEmpty()) {
                throw new RuntimeException(String.format("Command %s exited with non empty stdErr: %s", String.join((CharSequence)",", this.command), this.stdErr));
            }
            return this;
        }

        public int getExitValue() {
            return this.exitValue;
        }

        public String getStdErr() {
            return this.stdErr;
        }

        public String getStdOut() {
            return this.stdOut;
        }
    }

    private static class StreamGobbler
    extends Thread {
        private final StringBuilder buffer = new StringBuilder();
        private IOException exception;
        private final InputStream in;

        private StreamGobbler(InputStream in) {
            this.in = in;
        }

        public String getString() throws IOException {
            if (this.exception != null) {
                throw this.exception;
            }
            return this.buffer.toString();
        }

        @Override
        public void run() {
            try (InputStreamReader r = new InputStreamReader(this.in, StandardCharsets.UTF_8);){
                int ch;
                while ((ch = r.read()) >= 0) {
                    this.buffer.append((char)ch);
                }
            }
            catch (IOException e) {
                this.exception = e;
            }
        }
    }
}

