/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.client.helpers.domain.impl;

import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.client.helpers.domain.InitialDeploymentSetBuilder;
import org.jboss.as.controller.client.helpers.domain.impl.DeploymentContentDistributor;
import org.jboss.as.controller.client.helpers.domain.impl.DeploymentPlanBuilderImpl;
import org.jboss.as.controller.client.helpers.domain.impl.DeploymentSetPlanImpl;
import org.jboss.as.controller.client.logging.ControllerClientLogger;

public class InitialDeploymentSetBuilderImpl
extends DeploymentPlanBuilderImpl
implements InitialDeploymentSetBuilder {
    InitialDeploymentSetBuilderImpl(DeploymentContentDistributor deploymentDistributor) {
        super(deploymentDistributor);
    }

    InitialDeploymentSetBuilderImpl(DeploymentPlanBuilderImpl existing, boolean globalRollback) {
        super(existing, globalRollback);
    }

    InitialDeploymentSetBuilderImpl(DeploymentPlanBuilderImpl existing, DeploymentSetPlanImpl setPlan) {
        super(existing, setPlan);
    }

    @Override
    public InitialDeploymentSetBuilder withGracefulShutdown(long timeout, TimeUnit timeUnit) {
        DeploymentSetPlanImpl currentSet = this.getCurrentDeploymentSetPlan();
        long period = timeUnit.toMillis(timeout);
        if (currentSet.isShutdown() && period != currentSet.getGracefulShutdownTimeout()) {
            throw ControllerClientLogger.ROOT_LOGGER.gracefulShutdownAlreadyConfigured(currentSet.getGracefulShutdownTimeout());
        }
        DeploymentSetPlanImpl newSet = currentSet.setGracefulTimeout(period);
        return new InitialDeploymentSetBuilderImpl((DeploymentPlanBuilderImpl)this, newSet);
    }

    @Override
    public InitialDeploymentSetBuilder withShutdown() {
        DeploymentSetPlanImpl currentSet = this.getCurrentDeploymentSetPlan();
        DeploymentSetPlanImpl newSet = currentSet.setShutdown();
        return new InitialDeploymentSetBuilderImpl((DeploymentPlanBuilderImpl)this, newSet);
    }

    @Override
    public InitialDeploymentSetBuilder withoutSingleServerRollback() {
        DeploymentSetPlanImpl currentSet = this.getCurrentDeploymentSetPlan();
        DeploymentSetPlanImpl newSet = currentSet.setNoRollback();
        return new InitialDeploymentSetBuilderImpl((DeploymentPlanBuilderImpl)this, newSet);
    }
}

