/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.io.InputStream;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.jboss.as.controller.AbstractOperationContext;
import org.jboss.as.controller.CapabilityServiceTarget;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.ManagementModel;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.ModelControllerImpl;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationContextImpl;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ParsedBootOp;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.access.Action;
import org.jboss.as.controller.access.AuthorizationResult;
import org.jboss.as.controller.access.ResourceAuthorization;
import org.jboss.as.controller.audit.AuditLogger;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.client.MessageSeverity;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.notification.Notification;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.wildfly.security.auth.server.SecurityIdentity;

class ParallelBootOperationContext
extends AbstractOperationContext {
    private final OperationContextImpl primaryContext;
    private final List<ParsedBootOp> runtimeOps;
    private final Thread controllingThread;
    private final int operationId;
    private final ModelControllerImpl controller;

    ParallelBootOperationContext(ModelController.OperationTransactionControl transactionControl, ControlledProcessState processState, OperationContextImpl primaryContext, List<ParsedBootOp> runtimeOps, ModelControllerImpl controller, int operationId, AuditLogger auditLogger, OperationStepHandler extraValidationStepHandler, Supplier<SecurityIdentity> securityIdentitySupplier) {
        super(primaryContext.getProcessType(), primaryContext.getRunningMode(), transactionControl, processState, true, auditLogger, controller.getNotificationSupport(), controller, true, extraValidationStepHandler, null, securityIdentitySupplier);
        this.primaryContext = primaryContext;
        this.runtimeOps = runtimeOps;
        this.controller = controller;
        this.operationId = operationId;
        this.controllingThread = Thread.currentThread();
    }

    void setControllingThread() {
        AbstractOperationContext.controllingThread.set(this.controllingThread);
    }

    @Override
    public void close() {
        AbstractOperationContext.controllingThread.remove();
        this.lockStep = null;
        super.close();
    }

    @Override
    public void addStep(OperationStepHandler step, OperationContext.Stage stage) throws IllegalArgumentException {
        if (this.activeStep == null) {
            throw ControllerLogger.ROOT_LOGGER.noActiveStep();
        }
        this.addStep(this.activeStep.response, this.activeStep.operation, step, stage);
    }

    @Override
    public void addStep(ModelNode operation, OperationStepHandler step, OperationContext.Stage stage) throws IllegalArgumentException {
        if (this.activeStep == null) {
            throw ControllerLogger.ROOT_LOGGER.noActiveStep();
        }
        this.addStep(this.activeStep.response, operation, step, stage);
    }

    @Override
    public void addStep(ModelNode operation, OperationStepHandler step, OperationContext.Stage stage, boolean addFirst) throws IllegalArgumentException {
        if (this.activeStep == null) {
            throw ControllerLogger.ROOT_LOGGER.noActiveStep();
        }
        this.addStep(this.activeStep.response, operation, step, stage, addFirst);
    }

    @Override
    public void addStep(ModelNode response, ModelNode operation, OperationStepHandler step, OperationContext.Stage stage) throws IllegalArgumentException {
        if (stage == OperationContext.Stage.MODEL) {
            super.addStep(response, operation, step, stage);
        } else if (stage == OperationContext.Stage.RUNTIME) {
            if (this.runtimeOps != null) {
                ParsedBootOp parsedOp = new ParsedBootOp(operation, step, response);
                this.runtimeOps.add(parsedOp);
            } else {
                super.addStep(response, operation, step, stage);
            }
        } else {
            this.primaryContext.addStep(response, operation, step, stage);
        }
    }

    @Override
    ModelControllerImpl.ManagementModelImpl getManagementModel() {
        throw new IllegalStateException();
    }

    @Override
    boolean isBootOperation() {
        return true;
    }

    @Override
    public InputStream getAttachmentStream(int index) {
        return this.primaryContext.getAttachmentStream(index);
    }

    @Override
    public int getAttachmentStreamCount() {
        return this.primaryContext.getAttachmentStreamCount();
    }

    @Override
    public boolean isRollbackOnRuntimeFailure() {
        return this.primaryContext.isRollbackOnRuntimeFailure();
    }

    @Override
    public boolean isResourceServiceRestartAllowed() {
        return this.primaryContext.isResourceServiceRestartAllowed();
    }

    @Override
    public ImmutableManagementResourceRegistration getResourceRegistration() {
        ImmutableManagementResourceRegistration parent = this.primaryContext.getResourceRegistration();
        return parent.getSubModel(this.activeStep.address);
    }

    @Override
    public ManagementResourceRegistration getResourceRegistrationForUpdate() {
        this.acquireControllerLock();
        ManagementResourceRegistration parent = this.primaryContext.getResourceRegistrationForUpdate();
        return parent.getSubModel(this.activeStep.address);
    }

    @Override
    public ImmutableManagementResourceRegistration getRootResourceRegistration() {
        return this.primaryContext.getRootResourceRegistration();
    }

    @Override
    public ServiceRegistry getServiceRegistry(boolean modify) throws UnsupportedOperationException {
        if (modify) {
            this.acquireControllerLock();
        }
        return this.primaryContext.getServiceRegistry(modify, this.activeStep);
    }

    @Override
    public ServiceController<?> removeService(ServiceName name) throws UnsupportedOperationException {
        this.acquireControllerLock();
        return this.primaryContext.removeService(name);
    }

    @Override
    public void removeService(ServiceController<?> controller) throws UnsupportedOperationException {
        this.acquireControllerLock();
        this.primaryContext.removeService(controller);
    }

    @Override
    public CapabilityServiceTarget getServiceTarget() throws UnsupportedOperationException {
        return this.getCapabilityServiceTarget();
    }

    @Override
    public CapabilityServiceTarget getCapabilityServiceTarget() throws UnsupportedOperationException {
        this.acquireControllerLock();
        return this.primaryContext.getServiceTarget(this.activeStep);
    }

    @Override
    public void acquireControllerLock() {
        if (this.lockStep == null) {
            try {
                this.controller.acquireWriteLock(this.operationId, true);
                this.recordWriteLock();
            }
            catch (InterruptedException e) {
                this.cancelled = true;
                Thread.currentThread().interrupt();
                throw ControllerLogger.ROOT_LOGGER.operationCancelledAsynchronously();
            }
        }
    }

    @Override
    public Resource createResource(PathAddress address) throws UnsupportedOperationException {
        this.acquireControllerLock();
        PathAddress fullAddress = this.activeStep.address.append(address);
        return this.primaryContext.createResource(fullAddress);
    }

    @Override
    public void addResource(PathAddress address, Resource toAdd) {
        this.acquireControllerLock();
        PathAddress fullAddress = this.activeStep.address.append(address);
        this.primaryContext.addResource(fullAddress, toAdd);
    }

    @Override
    public void addResource(PathAddress address, int index, Resource toAdd) {
        this.acquireControllerLock();
        PathAddress fullAddress = this.activeStep.address.append(address);
        this.primaryContext.addResource(fullAddress, index, toAdd);
    }

    @Override
    public Resource readResource(PathAddress address) {
        return this.readResource(address, true);
    }

    @Override
    public Resource readResource(PathAddress address, boolean recursive) {
        PathAddress fullAddress = this.activeStep.address.append(address);
        return this.primaryContext.readResource(fullAddress, recursive);
    }

    @Override
    public Resource readResourceFromRoot(PathAddress address) {
        return this.readResourceFromRoot(address, true);
    }

    @Override
    public Resource readResourceFromRoot(PathAddress address, boolean recursive) {
        return this.primaryContext.readResourceFromRoot(address, recursive);
    }

    @Override
    protected Resource readResourceFromRoot(ManagementModel model, PathAddress address, boolean recursive) {
        return this.primaryContext.readResourceFromRoot(model, address, recursive);
    }

    @Override
    public Resource readResourceForUpdate(PathAddress address) {
        this.acquireControllerLock();
        PathAddress fullAddress = this.activeStep.address.append(address);
        return this.primaryContext.readResourceForUpdate(fullAddress);
    }

    @Override
    public Resource removeResource(PathAddress address) throws UnsupportedOperationException {
        this.acquireControllerLock();
        PathAddress fullAddress = this.activeStep.address.append(address);
        return this.primaryContext.removeResource(fullAddress);
    }

    @Override
    public Resource getOriginalRootResource() {
        return this.primaryContext.getOriginalRootResource();
    }

    @Override
    public boolean isModelAffected() {
        return this.primaryContext.isModelAffected();
    }

    @Override
    public boolean isResourceRegistryAffected() {
        return this.primaryContext.isResourceRegistryAffected();
    }

    @Override
    public boolean isRuntimeAffected() {
        return this.primaryContext.isRuntimeAffected();
    }

    @Override
    public OperationContext.Stage getCurrentStage() {
        return this.primaryContext.getCurrentStage();
    }

    @Override
    public void report(MessageSeverity severity, String message) {
        this.primaryContext.report(severity, message);
    }

    @Override
    public boolean markResourceRestarted(PathAddress resource, Object owner) {
        throw new UnsupportedOperationException("Resource restarting is not supported during boot");
    }

    @Override
    public boolean revertResourceRestarted(PathAddress resource, Object owner) {
        throw new UnsupportedOperationException("Resource restarting is not supported during boot");
    }

    @Override
    void awaitServiceContainerStability() throws InterruptedException {
    }

    @Override
    ConfigurationPersister.PersistenceResource createPersistenceResource() throws ConfigurationPersistenceException {
        return null;
    }

    @Override
    void operationRollingBack() {
    }

    @Override
    public void emit(Notification notification) {
        this.primaryContext.emit(notification);
    }

    @Override
    public void registerCapability(RuntimeCapability capability) {
        this.primaryContext.registerCapability(capability, this.activeStep, null);
    }

    @Override
    public void registerAdditionalCapabilityRequirement(String required, String dependent, String attribute) {
        this.primaryContext.registerAdditionalCapabilityRequirement(required, dependent, this.activeStep, attribute);
    }

    @Override
    public boolean hasOptionalCapability(String required, String dependent, String attribute) {
        return this.primaryContext.requestOptionalCapability(required, dependent, true, this.activeStep, attribute);
    }

    @Override
    public void requireOptionalCapability(String required, String dependent, String attribute) throws OperationFailedException {
        this.primaryContext.requireOptionalCapability(required, dependent, this.activeStep, attribute);
    }

    @Override
    public void deregisterCapabilityRequirement(String required, String dependent) {
        this.deregisterCapabilityRequirement(required, dependent, null);
    }

    @Override
    public void deregisterCapabilityRequirement(String required, String dependent, String attribute) {
        this.primaryContext.removeCapabilityRequirement(required, dependent, this.activeStep, attribute);
    }

    @Override
    public void deregisterCapability(String capability) {
        this.primaryContext.removeCapability(capability, this.activeStep);
    }

    @Override
    public <T> T getCapabilityRuntimeAPI(String capabilityName, Class<T> apiType) {
        return this.primaryContext.getCapabilityRuntimeAPI(capabilityName, apiType, this.activeStep);
    }

    @Override
    public <T> T getCapabilityRuntimeAPI(String capabilityBaseName, String dynamicPart, Class<T> apiType) {
        return this.primaryContext.getCapabilityRuntimeAPI(RuntimeCapability.buildDynamicCapabilityName(capabilityBaseName, dynamicPart), apiType, this.activeStep);
    }

    @Override
    public ServiceName getCapabilityServiceName(String capabilityName, Class<?> type) {
        return this.primaryContext.getCapabilityServiceName(capabilityName, type, this.activeStep.address);
    }

    @Override
    public ServiceName getCapabilityServiceName(String capabilityBaseName, Class<?> serviceType, String ... dynamicParts) {
        return this.primaryContext.getCapabilityServiceName(capabilityBaseName, serviceType, dynamicParts);
    }

    @Override
    public ServiceName getCapabilityServiceName(String capabilityBaseName, String dynamicPart, Class<?> serviceType) {
        return this.primaryContext.getCapabilityServiceName(capabilityBaseName, dynamicPart, serviceType);
    }

    @Override
    public CapabilityServiceSupport getCapabilityServiceSupport() {
        return this.primaryContext.getCapabilityServiceSupport();
    }

    @Override
    void releaseStepLocks(AbstractOperationContext.AbstractStep step) {
        if (step.matches(this.lockStep)) {
            this.controller.releaseWriteLock(this.operationId);
            this.lockStep = null;
        }
    }

    @Override
    void waitForRemovals() {
    }

    @Override
    boolean isReadOnly() {
        return this.primaryContext.isReadOnly();
    }

    @Override
    ManagementResourceRegistration getRootResourceRegistrationForUpdate() {
        return this.primaryContext.getRootResourceRegistrationForUpdate();
    }

    @Override
    public ModelNode resolveExpressions(ModelNode node) throws OperationFailedException {
        return this.primaryContext.resolveExpressions(node);
    }

    @Override
    public <T> T getAttachment(OperationContext.AttachmentKey<T> key) {
        return this.primaryContext.getAttachment(key);
    }

    @Override
    public <T> T attach(OperationContext.AttachmentKey<T> key, T value) {
        return this.primaryContext.attach(key, value);
    }

    @Override
    public <T> T attachIfAbsent(OperationContext.AttachmentKey<T> key, T value) {
        return this.primaryContext.attachIfAbsent(key, value);
    }

    @Override
    public <T> T detach(OperationContext.AttachmentKey<T> key) {
        return this.primaryContext.detach(key);
    }

    @Override
    public AuthorizationResult authorize(ModelNode operation) {
        return this.primaryContext.authorize(operation);
    }

    @Override
    public AuthorizationResult authorize(ModelNode operation, Set<Action.ActionEffect> effects) {
        return this.primaryContext.authorize(operation, effects);
    }

    @Override
    public AuthorizationResult authorize(ModelNode operation, String attribute, ModelNode currentValue) {
        return this.primaryContext.authorize(operation, attribute, currentValue);
    }

    @Override
    public AuthorizationResult authorize(ModelNode operation, String attribute, ModelNode currentValue, Set<Action.ActionEffect> effects) {
        return this.primaryContext.authorize(operation, attribute, currentValue, effects);
    }

    @Override
    public AuthorizationResult authorizeOperation(ModelNode operation) {
        return this.primaryContext.authorizeOperation(operation);
    }

    @Override
    public ResourceAuthorization authorizeResource(boolean attributes, boolean isDefaultResource) {
        return this.primaryContext.authorizeResource(attributes, isDefaultResource);
    }

    @Override
    Resource getModel() {
        return this.primaryContext.getModel();
    }

    @Override
    void logAuditRecord() {
    }
}

