/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.net.InetAddress;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.as.controller.security.ControllerPermission;
import org.jboss.as.core.security.AccessMechanism;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.manager.WildFlySecurityManager;

public class AccessAuditContext {
    private static ThreadLocal<AccessAuditContext> contextThreadLocal = new ThreadLocal();
    private final boolean inflowed;
    private final SecurityIdentity securityIdentity;
    private final InetAddress remoteAddress;
    private String domainUuid;
    private AccessMechanism accessMechanism;
    private boolean domainRollout;

    private AccessAuditContext(boolean inflowed, SecurityIdentity securityIdentity, InetAddress remoteAddress, AccessAuditContext previous) {
        this.securityIdentity = securityIdentity;
        if (previous != null) {
            this.domainUuid = previous.domainUuid;
            this.accessMechanism = previous.accessMechanism;
            this.domainRollout = previous.domainRollout;
            this.remoteAddress = previous.remoteAddress;
            this.inflowed = previous.inflowed;
        } else {
            this.inflowed = inflowed;
            this.remoteAddress = remoteAddress;
        }
        if (this.inflowed && WildFlySecurityManager.isChecking()) {
            System.getSecurityManager().checkPermission(ControllerPermission.INFLOW_SECURITY_IDENTITY);
        }
    }

    public SecurityIdentity getSecurityIdentity() {
        return this.securityIdentity;
    }

    public boolean isInflowed() {
        return this.inflowed;
    }

    public InetAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public String getDomainUuid() {
        return this.domainUuid;
    }

    public void setDomainUuid(String domainUuid) {
        this.domainUuid = domainUuid;
    }

    public AccessMechanism getAccessMechanism() {
        return this.accessMechanism;
    }

    public void setAccessMechanism(AccessMechanism accessMechanism) {
        this.accessMechanism = accessMechanism;
    }

    public boolean isDomainRollout() {
        return this.domainRollout;
    }

    public void setDomainRollout(boolean domainRollout) {
        this.domainRollout = domainRollout;
    }

    @Deprecated
    public static AccessAuditContext currentAccessAuditContext() {
        if (WildFlySecurityManager.isChecking()) {
            System.getSecurityManager().checkPermission(ControllerPermission.GET_CURRENT_ACCESS_AUDIT_CONTEXT);
        }
        return contextThreadLocal.get();
    }

    public static <T> T doAs(SecurityIdentity securityIdentity, InetAddress remoteAddress, PrivilegedAction<T> action) {
        return AccessAuditContext.doAs(false, securityIdentity, remoteAddress, action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T doAs(boolean inflowed, SecurityIdentity securityIdentity, InetAddress remoteAddress, PrivilegedAction<T> action) {
        AccessAuditContext previous = contextThreadLocal.get();
        try {
            contextThreadLocal.set(new AccessAuditContext(inflowed, securityIdentity, remoteAddress, previous));
            Object object = securityIdentity != null ? securityIdentity.runAs(action) : action.run();
            return object;
        }
        finally {
            contextThreadLocal.set(previous);
        }
    }

    public static <T> T doAs(SecurityIdentity securityIdentity, InetAddress remoteAddress, PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
        return AccessAuditContext.doAs(false, securityIdentity, remoteAddress, action);
    }

    public static <T> T doAs(boolean inflowed, SecurityIdentity securityIdentity, InetAddress remoteAddress, PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
        AccessAuditContext previous = contextThreadLocal.get();
        try {
            contextThreadLocal.set(new AccessAuditContext(inflowed, securityIdentity, remoteAddress, previous));
            if (securityIdentity != null) {
                Object object = securityIdentity.runAs(action);
                return (T)object;
            }
            T t = action.run();
            return t;
        }
        finally {
            contextThreadLocal.set(previous);
        }
    }
}

