/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.validation;

import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.validation.MinMaxValidator;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class StringLengthValidator
extends ModelTypeValidator
implements MinMaxValidator {
    protected final int min;
    protected final int max;

    public StringLengthValidator(int min) {
        this(min, Integer.MAX_VALUE, false, false);
    }

    public StringLengthValidator(int min, int max) {
        this(min, max, false, false);
    }

    public StringLengthValidator(int min, boolean nullable) {
        this(min, Integer.MAX_VALUE, nullable, false);
    }

    public StringLengthValidator(int min, int max, boolean nullable, boolean allowExpressions) {
        super(ModelType.STRING, nullable, allowExpressions, false);
        this.min = min;
        this.max = max;
    }

    public StringLengthValidator(int min, boolean nullable, boolean allowExpressions) {
        this(min, Integer.MAX_VALUE, nullable, allowExpressions);
    }

    @Override
    public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
        super.validateParameter(parameterName, value);
        if (value.isDefined() && value.getType() != ModelType.EXPRESSION) {
            String str = value.asString();
            if (str.length() < this.min) {
                throw new OperationFailedException(ControllerLogger.ROOT_LOGGER.invalidMinLength(str, parameterName, this.min));
            }
            if (str.length() > this.max) {
                throw new OperationFailedException(ControllerLogger.ROOT_LOGGER.invalidMaxLength(str, parameterName, this.max));
            }
        }
    }

    @Override
    public Long getMin() {
        return this.min;
    }

    @Override
    public Long getMax() {
        return this.max;
    }
}

