/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityReferenceRecorder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDescriptor;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;

public abstract class AbstractAddStepHandler
implements OperationStepHandler,
OperationDescriptor {
    private static final String AUTO_POPULATE_MODEL = "auto-populate-model";
    @Deprecated(forRemoval=true)
    protected final Collection<? extends AttributeDefinition> attributes;

    public AbstractAddStepHandler() {
        this.attributes = List.of();
    }

    @Deprecated(forRemoval=true)
    public AbstractAddStepHandler(Collection<? extends AttributeDefinition> attributes) {
        this.attributes = attributes instanceof Set ? Set.copyOf((Set)attributes) : List.copyOf(attributes);
    }

    @Deprecated(forRemoval=true)
    public AbstractAddStepHandler(AttributeDefinition ... attributes) {
        this(List.of(attributes));
    }

    @Deprecated(forRemoval=true)
    public AbstractAddStepHandler(Parameters parameters) {
        this.attributes = parameters.attributes;
    }

    @Override
    @Deprecated(forRemoval=true)
    public Collection<? extends AttributeDefinition> getAttributes() {
        return this.attributes;
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        final Resource resource = this.createResource(context, operation);
        this.populateModel(context, operation, resource);
        this.recordCapabilitiesAndRequirements(context, operation, resource);
        if (this.requiresRuntime(context)) {
            context.addStep(new OperationStepHandler(){

                @Override
                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    AbstractAddStepHandler.this.performRuntime(context, operation, resource);
                    context.completeStep(new OperationContext.RollbackHandler(){

                        @Override
                        public void handleRollback(OperationContext context, ModelNode operation) {
                            AbstractAddStepHandler.this.rollbackRuntime(context, operation, resource);
                        }
                    });
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }

    protected Resource createResource(OperationContext context, ModelNode operation) {
        ImmutableManagementResourceRegistration registration = context.getResourceRegistration();
        if (registration != null) {
            Set<String> orderedChildTypes = registration.getOrderedChildTypes();
            boolean orderedChildResource = registration.isOrderedChildResource();
            if (orderedChildResource || !orderedChildTypes.isEmpty()) {
                return new OrderedResourceCreator(orderedChildResource, orderedChildTypes).createResource(context, operation);
            }
        }
        return this.createResource(context);
    }

    protected Resource createResource(OperationContext context) {
        return context.createResource(PathAddress.EMPTY_ADDRESS);
    }

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        this.populateModel(operation, resource);
        if (operation.hasDefined(new String[]{"operation-headers", AUTO_POPULATE_MODEL})) {
            ModelNode model = resource.getModel();
            ImmutableManagementResourceRegistration registration = context.getResourceRegistration();
            Map<String, AttributeAccess> attributes = registration.getAttributes(PathAddress.EMPTY_ADDRESS);
            for (AttributeDefinition parameter : registration.getOperationEntry(PathAddress.EMPTY_ADDRESS, "add").getOperationDefinition().getParameters()) {
                AttributeAccess attribute = attributes.get(parameter.getName());
                if (attribute != null && !AttributeAccess.Flag.ALIAS.test(attribute)) {
                    parameter.validateAndSet(operation, model);
                    continue;
                }
                parameter.validateOperation(operation);
            }
            operation.get("operation-headers").remove(AUTO_POPULATE_MODEL);
        }
    }

    @Deprecated(forRemoval=true)
    protected void populateModel(ModelNode operation, Resource resource) throws OperationFailedException {
        this.populateModel(operation, resource.getModel());
    }

    @Deprecated(forRemoval=true)
    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        operation.get(new String[]{"operation-headers", AUTO_POPULATE_MODEL}).set(true);
    }

    protected void recordCapabilitiesAndRequirements(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        ImmutableManagementResourceRegistration registration = context.getResourceRegistration();
        for (RuntimeCapability capability : registration.getCapabilities()) {
            if (capability.isDynamicallyNamed()) {
                context.registerCapability(capability.fromBaseCapability(context.getCurrentAddress()));
                continue;
            }
            context.registerCapability(capability);
        }
        ModelNode model = resource.getModel();
        for (AttributeAccess attribute : registration.getAttributes(PathAddress.EMPTY_ADDRESS).values()) {
            AttributeDefinition definition;
            String attributeName;
            if (AttributeAccess.Storage.RUNTIME.test(attribute) || AttributeAccess.Flag.ALIAS.test(attribute) || !model.hasDefined(attributeName = (definition = attribute.getAttributeDefinition()).getName()) && !definition.hasCapabilityRequirements()) continue;
            definition.addCapabilityRequirements(context, resource, model.get(attributeName));
        }
        assert (registration.getRequirements() != null);
        for (CapabilityReferenceRecorder recorder : registration.getRequirements()) {
            recorder.addCapabilityRequirements(context, resource, null, new String[0]);
        }
    }

    protected boolean requiresRuntime(OperationContext context) {
        return context.isDefaultRequiresRuntime();
    }

    protected void performRuntime(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        this.performRuntime(context, operation, resource.getModel());
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, Resource resource) {
    }

    private static class ImmutableListSet<T>
    extends AbstractSet<T> {
        private final List<T> list;

        ImmutableListSet(List<T> list) {
            this.list = list;
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public Iterator<T> iterator() {
            return this.list.iterator();
        }

        @Override
        public boolean add(T e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            throw new UnsupportedOperationException();
        }
    }

    @Deprecated(forRemoval=true)
    public static class Parameters {
        protected Set<AttributeDefinition> attributes = Set.of();

        public Parameters addAttribute(AttributeDefinition ... attributes) {
            return this.addAttribute(List.of(attributes));
        }

        public Parameters addAttribute(Collection<? extends AttributeDefinition> attributes) {
            if (this.attributes.isEmpty()) {
                this.attributes = attributes instanceof List ? new ImmutableListSet<AttributeDefinition>(List.copyOf(attributes)) : Set.copyOf(attributes);
            } else {
                ArrayList<? extends AttributeDefinition> newAttributes = new ArrayList<AttributeDefinition>(this.attributes.size() + attributes.size());
                newAttributes.addAll(this.attributes);
                newAttributes.addAll(attributes);
                this.attributes = new ImmutableListSet(newAttributes);
            }
            return this;
        }
    }

    private static class OrderedResourceCreator
    implements ResourceCreator {
        private final Set<String> orderedChildTypes;
        private final boolean indexedAdd;

        public OrderedResourceCreator(boolean indexedAdd, Set<String> orderedChildTypes) {
            this.indexedAdd = indexedAdd;
            this.orderedChildTypes = orderedChildTypes == null ? Collections.emptySet() : orderedChildTypes;
        }

        @Override
        public Resource createResource(OperationContext context, ModelNode operation) {
            Resource resource = Resource.Factory.create(false, this.orderedChildTypes);
            int index = -1;
            if (this.indexedAdd && operation.hasDefined("add-index")) {
                index = operation.get("add-index").asInt();
            }
            if (index >= 0) {
                context.addResource(PathAddress.EMPTY_ADDRESS, operation.get("add-index").asInt(), resource);
            } else {
                context.addResource(PathAddress.EMPTY_ADDRESS, resource);
            }
            return resource;
        }
    }

    private static interface ResourceCreator {
        public Resource createResource(OperationContext var1, ModelNode var2);
    }
}

