/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.capability.registry;

import java.util.Collections;
import java.util.Set;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.capability.registry.CapabilityResolutionContext;
import org.jboss.as.controller.capability.registry.HostCapabilityScope;
import org.jboss.as.controller.capability.registry.ProfileChildCapabilityScope;
import org.jboss.as.controller.capability.registry.ProfilesCapabilityScope;
import org.jboss.as.controller.capability.registry.ServerConfigCapabilityScope;
import org.jboss.as.controller.capability.registry.ServerGroupsCapabilityScope;
import org.jboss.as.controller.capability.registry.SocketBindingGroupChildScope;
import org.jboss.as.controller.capability.registry.SocketBindingGroupsCapabilityScope;

public interface CapabilityScope {
    public static final CapabilityScope GLOBAL = new CapabilityScope(){

        @Override
        public boolean canSatisfyRequirement(String requiredName, CapabilityScope dependentScope, CapabilityResolutionContext context) {
            return true;
        }

        @Override
        public boolean requiresConsistencyCheck() {
            return false;
        }

        @Override
        public String getName() {
            return "global";
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{global}";
        }
    };

    public boolean canSatisfyRequirement(String var1, CapabilityScope var2, CapabilityResolutionContext var3);

    public boolean requiresConsistencyCheck();

    public String getName();

    default public Set<CapabilityScope> getIncludingScopes(CapabilityResolutionContext context) {
        return Collections.emptySet();
    }

    public static class Factory {
        public static CapabilityScope create(ProcessType processType, PathAddress address) {
            PathElement pe;
            CapabilityScope context = GLOBAL;
            PathElement pathElement = pe = processType.isServer() || address.size() == 0 ? null : address.getElement(0);
            if (pe != null) {
                String type;
                switch (type = pe.getKey()) {
                    case "profile": {
                        context = address.size() == 1 ? ProfilesCapabilityScope.INSTANCE : new ProfileChildCapabilityScope(pe.getValue());
                        break;
                    }
                    case "socket-binding-group": {
                        context = address.size() == 1 ? SocketBindingGroupsCapabilityScope.INSTANCE : new SocketBindingGroupChildScope(pe.getValue());
                        break;
                    }
                    case "host": {
                        String hostType;
                        if (address.size() < 2) break;
                        PathElement hostElement = address.getElement(1);
                        switch (hostType = hostElement.getKey()) {
                            case "subsystem": 
                            case "socket-binding-group": {
                                context = HostCapabilityScope.INSTANCE;
                                break;
                            }
                            case "server-config": {
                                context = ServerConfigCapabilityScope.INSTANCE;
                            }
                        }
                        break;
                    }
                    case "server-group": {
                        context = ServerGroupsCapabilityScope.INSTANCE;
                    }
                }
            }
            return context;
        }

        public static CapabilityScope forName(String name) {
            boolean dynamic = name.contains("=");
            String key = dynamic ? name.substring(0, name.indexOf("=")) : name;
            String value = dynamic ? name.substring(name.indexOf("=") + 1) : null;
            CapabilityScope context = GLOBAL;
            switch (key) {
                case "profile": {
                    context = dynamic ? new ProfileChildCapabilityScope(value) : ProfilesCapabilityScope.INSTANCE;
                    break;
                }
                case "socket-binding-group": {
                    context = dynamic ? new SocketBindingGroupChildScope(value) : SocketBindingGroupsCapabilityScope.INSTANCE;
                    break;
                }
                case "server-group": {
                    context = ServerGroupsCapabilityScope.INSTANCE;
                    break;
                }
                case "server-config": {
                    context = ServerConfigCapabilityScope.INSTANCE;
                }
            }
            return context;
        }
    }
}

