/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.descriptions;

import java.lang.ref.WeakReference;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;

public class StandardResourceDescriptionResolver
implements ResourceDescriptionResolver {
    public static final String REPLY = "reply";
    private final String keyPrefix;
    private final String bundleBaseName;
    private final WeakReference<ClassLoader> bundleLoader;
    private final boolean reuseAttributesForAdd;
    private final boolean useUnprefixedChildTypes;

    public StandardResourceDescriptionResolver(String keyPrefix, String bundleBaseName, ClassLoader bundleLoader) {
        this(keyPrefix, bundleBaseName, bundleLoader, false, false);
    }

    public StandardResourceDescriptionResolver(String keyPrefix, String bundleBaseName, ClassLoader bundleLoader, boolean reuseAttributesForAdd, boolean useUnprefixedChildTypes) {
        this.keyPrefix = keyPrefix;
        this.bundleBaseName = bundleBaseName;
        this.bundleLoader = new WeakReference<ClassLoader>(bundleLoader);
        this.reuseAttributesForAdd = reuseAttributesForAdd;
        this.useUnprefixedChildTypes = useUnprefixedChildTypes;
    }

    public String getKeyPrefix() {
        return this.keyPrefix;
    }

    public boolean isReuseAttributesForAdd() {
        return this.reuseAttributesForAdd;
    }

    public boolean isUseUnprefixedChildTypes() {
        return this.useUnprefixedChildTypes;
    }

    public StandardResourceDescriptionResolver getChildResolver(String key) {
        return new StandardResourceDescriptionResolver(this.keyPrefix + "." + key, this.bundleBaseName, (ClassLoader)this.bundleLoader.get(), this.reuseAttributesForAdd, this.useUnprefixedChildTypes);
    }

    @Override
    public ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(this.bundleBaseName, locale, (ClassLoader)this.bundleLoader.get());
    }

    @Override
    public String getResourceDescription(Locale locale, ResourceBundle bundle) {
        return bundle.getString(this.getBundleKey(new String[0]));
    }

    @Override
    public String getResourceAttributeDescription(String attributeName, Locale locale, ResourceBundle bundle) {
        return bundle.getString(this.getBundleKey(attributeName));
    }

    @Override
    public String getResourceAttributeValueTypeDescription(String attributeName, Locale locale, ResourceBundle bundle, String ... suffixes) {
        return bundle.getString(this.getVariableBundleKey(new String[]{attributeName}, suffixes));
    }

    @Override
    public String getOperationDescription(String operationName, Locale locale, ResourceBundle bundle) {
        return bundle.getString(this.getBundleKey(operationName));
    }

    @Override
    public String getOperationParameterDescription(String operationName, String paramName, Locale locale, ResourceBundle bundle) {
        if (this.reuseAttributesForAdd && "add".equals(operationName)) {
            return bundle.getString(this.getBundleKey(paramName));
        }
        return bundle.getString(this.getBundleKey(operationName, paramName));
    }

    @Override
    public String getOperationParameterValueTypeDescription(String operationName, String paramName, Locale locale, ResourceBundle bundle, String ... suffixes) {
        String[] fixed = this.reuseAttributesForAdd && "add".equals(operationName) ? new String[]{paramName} : new String[]{operationName, paramName};
        return bundle.getString(this.getVariableBundleKey(fixed, suffixes));
    }

    @Override
    public String getOperationReplyDescription(String operationName, Locale locale, ResourceBundle bundle) {
        try {
            return bundle.getString(this.getBundleKey(operationName, REPLY));
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    @Override
    public String getOperationReplyValueTypeDescription(String operationName, Locale locale, ResourceBundle bundle, String ... suffixes) {
        try {
            return bundle.getString(this.getVariableBundleKey(new String[]{operationName, REPLY}, suffixes));
        }
        catch (MissingResourceException e) {
            try {
                return this.getOperationParameterValueTypeDescription(operationName, suffixes[0], locale, bundle, new String[0]);
            }
            catch (MissingResourceException ex) {
                throw e;
            }
        }
    }

    @Override
    public String getNotificationDescription(String notificationType, Locale locale, ResourceBundle bundle) {
        return bundle.getString(this.getBundleKey(notificationType));
    }

    @Override
    public String getChildTypeDescription(String childType, Locale locale, ResourceBundle bundle) {
        String bundleKey = this.useUnprefixedChildTypes ? childType : this.getBundleKey(childType);
        return bundle.getString(bundleKey);
    }

    @Override
    public String getResourceDeprecatedDescription(Locale locale, ResourceBundle bundle) {
        return bundle.getString(this.getBundleKey("deprecated"));
    }

    @Override
    public String getResourceAttributeDeprecatedDescription(String attributeName, Locale locale, ResourceBundle bundle) {
        return bundle.getString(this.getBundleKey(attributeName, "deprecated"));
    }

    @Override
    public String getOperationDeprecatedDescription(String operationName, Locale locale, ResourceBundle bundle) {
        return bundle.getString(this.getBundleKey(operationName, "deprecated"));
    }

    @Override
    public String getOperationParameterDeprecatedDescription(String operationName, String paramName, Locale locale, ResourceBundle bundle) {
        if (this.reuseAttributesForAdd && "add".equals(operationName)) {
            return bundle.getString(this.getBundleKey(paramName, "deprecated"));
        }
        return bundle.getString(this.getBundleKey(operationName, paramName, "deprecated"));
    }

    protected String getBundleKey(String ... args) {
        return this.getVariableBundleKey(args, new String[0]);
    }

    private String getVariableBundleKey(String[] fixed, String ... variable) {
        StringBuilder sb = new StringBuilder(this.keyPrefix);
        for (String arg : fixed) {
            if (sb.length() > 0) {
                sb.append('.');
            }
            sb.append(arg);
        }
        if (variable != null) {
            for (String arg : variable) {
                if (sb.length() > 0) {
                    sb.append('.');
                }
                sb.append(arg);
            }
        }
        return sb.toString();
    }
}

