/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.msc.service.ServiceName;

public final class ServiceNameFactory {
    private static final Map<ServiceName, ServiceName> cache = new ConcurrentHashMap<ServiceName, ServiceName>();

    public static ServiceName parseServiceName(String toParse) {
        ServiceName original = ServiceName.parse((String)toParse);
        int length = original.length();
        ServiceName[] ancestry = new ServiceName[length];
        ServiceName sn = original;
        for (int i = length - 1; i >= 0; --i) {
            ancestry[i] = sn;
            sn = sn.getParent();
        }
        int max = length > 4 ? length - 1 : length;
        for (int i = 0; i < max; ++i) {
            ServiceName interned = cache.putIfAbsent(ancestry[i], ancestry[i]);
            if (interned == null || ancestry[i] == interned) continue;
            ServiceName parent = ancestry[i] = interned;
            for (int j = i + 1; j < length; ++j) {
                ancestry[j] = parent = parent.append(new String[]{ancestry[j].getSimpleName()});
            }
        }
        return ancestry[length - 1];
    }

    static void clearCache() {
        cache.clear();
    }
}

