/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.scanner;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.server.deployment.scanner.DeploymentScannerDefinition;
import org.jboss.as.server.deployment.scanner.logging.DeploymentScannerLogger;
import org.jboss.dmr.ModelNode;

public class WritePathAttributeHandler
extends ReloadRequiredWriteAttributeHandler {
    private final PathManager pathManager;

    public WritePathAttributeHandler(PathManager pathManager) {
        super(new AttributeDefinition[]{DeploymentScannerDefinition.PATH});
        this.pathManager = pathManager;
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, final ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> voidHandback) throws OperationFailedException {
        boolean reloadRequired = super.applyUpdateToRuntime(context, operation, attributeName, resolvedValue, currentValue, voidHandback);
        if (reloadRequired) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    Path fullPath;
                    ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
                    ModelNode relativeTo = DeploymentScannerDefinition.RELATIVE_TO.resolveModelAttribute(context, model);
                    if (relativeTo.isDefined()) {
                        String fullPathName = WritePathAttributeHandler.this.pathManager.resolveRelativePathEntry(resolvedValue.asString(), relativeTo.asString());
                        fullPath = Paths.get(fullPathName, new String[0]);
                    } else {
                        fullPath = Paths.get(resolvedValue.asString(), new String[0]);
                    }
                    if (!Files.exists(fullPath, new LinkOption[0])) {
                        DeploymentScannerLogger.ROOT_LOGGER.directoryIsNonexistent(fullPath.toString());
                    } else if (!Files.isDirectory(fullPath, new LinkOption[0])) {
                        DeploymentScannerLogger.ROOT_LOGGER.isNotADirectory(fullPath.toString());
                    } else if (!Files.isReadable(fullPath)) {
                        DeploymentScannerLogger.ROOT_LOGGER.directoryIsNotReadable(fullPath.toString());
                    } else if (!Files.isWritable(fullPath)) {
                        DeploymentScannerLogger.ROOT_LOGGER.directoryIsNotWritable(fullPath.toString());
                    }
                }
            }, OperationContext.Stage.RUNTIME);
        }
        return reloadRequired;
    }
}

