/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security.adduser;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.as.domain.management.security.adduser.ConsoleWrapper;
import org.jboss.as.domain.management.security.adduser.ErrorState;
import org.jboss.as.domain.management.security.adduser.JavaConsole;
import org.jboss.as.domain.management.security.adduser.PropertyFileFinder;
import org.jboss.as.domain.management.security.adduser.PropertyFilePrompt;
import org.jboss.as.domain.management.security.adduser.RuntimeOptions;
import org.jboss.as.domain.management.security.adduser.State;
import org.jboss.as.domain.management.security.adduser.StateValues;
import org.jboss.as.domain.management.security.password.PasswordCheckUtil;

public class AddUser {
    private static final String JBOSS_HOME_ENV = "JBOSS_HOME";
    public static final String SERVER_BASE_DIR = "jboss.server.base.dir";
    public static final String SERVER_CONFIG_DIR = "jboss.server.config.dir";
    public static final String SERVER_CONFIG_USER_DIR = "jboss.server.config.user.dir";
    public static final String DOMAIN_BASE_DIR = "jboss.domain.base.dir";
    public static final String DOMAIN_CONFIG_DIR = "jboss.domain.config.dir";
    public static final String DOMAIN_CONFIG_USER_DIR = "jboss.domain.config.user.dir";
    public static final String CONFIG_FILE = "add-user.properties";
    public static final String DEFAULT_MANAGEMENT_REALM = "ManagementRealm";
    public static final String DEFAULT_APPLICATION_REALM = "ApplicationRealm";
    public static final String MGMT_USERS_PROPERTIES = "mgmt-users.properties";
    public static final String MGMT_GROUPS_PROPERTIES = "mgmt-groups.properties";
    public static final String APPLICATION_USERS_PROPERTIES = "application-users.properties";
    public static final String APPLICATION_ROLES_PROPERTIES = "application-roles.properties";
    public static final String NEW_LINE = String.format("%n", new Object[0]);
    public static final String SPACE = " ";
    private static final Properties argsCliProps = new Properties();
    private final ConsoleWrapper theConsole;
    protected State nextState;

    protected AddUser(RuntimeOptions options, String realm) {
        this.theConsole = options.getConsoleWrapper();
        StateValues stateValues = new StateValues(options);
        if (realm != null) {
            stateValues.setRealm(realm);
            stateValues.setRealmMode(RealmMode.USER_SUPPLIED);
        }
        if (!this.theConsole.hasConsole()) {
            throw DomainManagementLogger.ROOT_LOGGER.noConsoleAvailable();
        }
        this.nextState = options.getUserProperties() != null || options.getGroupProperties() != null ? new PropertyFileFinder(this.theConsole, stateValues) : new PropertyFilePrompt(this.theConsole, stateValues);
    }

    private AddUser(RuntimeOptions options, FileMode fileMode, String user, String password, String realm, RealmMode realmMode) {
        StateValues stateValues = new StateValues(options);
        boolean silent = Boolean.parseBoolean(argsCliProps.getProperty(CommandLineArgument.SILENT.key()));
        this.theConsole = options.getConsoleWrapper();
        Interactiveness howInteractive = silent ? Interactiveness.SILENT : Interactiveness.NON_INTERACTIVE;
        stateValues.setHowInteractive(howInteractive);
        boolean shouldDisplaySecret = Boolean.parseBoolean(argsCliProps.getProperty(CommandLineArgument.DISPLAY_SECRET.key()));
        stateValues.setDisplaySecret(shouldDisplaySecret);
        if (user == null || user.isEmpty()) {
            this.nextState = new ErrorState(this.theConsole, DomainManagementLogger.ROOT_LOGGER.noUsernameExiting(), null, stateValues);
            return;
        }
        stateValues.setUserName(user);
        if (!options.isEnableDisableMode() && (password == null || password.isEmpty())) {
            this.nextState = new ErrorState(this.theConsole, DomainManagementLogger.ROOT_LOGGER.noPasswordExiting(), null, stateValues);
            return;
        }
        stateValues.setPassword(password);
        stateValues.setRealm(realm);
        stateValues.setRealmMode(realmMode);
        stateValues.setFileMode(fileMode);
        String groups = argsCliProps.getProperty(CommandLineArgument.GROUPS.key());
        if (groups == null) {
            groups = argsCliProps.getProperty(CommandLineArgument.ROLE.key());
        }
        stateValues.setGroups(groups);
        this.nextState = new PropertyFileFinder(this.theConsole, stateValues);
    }

    private AddUser(RuntimeOptions options, FileMode fileMode, String user, String password) {
        this(options, fileMode, user, password, fileMode == FileMode.MANAGEMENT ? DEFAULT_MANAGEMENT_REALM : DEFAULT_APPLICATION_REALM, RealmMode.DEFAULT);
    }

    protected void run() {
        while ((this.nextState = this.nextState.execute()) != null) {
        }
    }

    public static void main(String[] args) {
        FileMode fileMode = FileMode.MANAGEMENT;
        RuntimeOptions options = new RuntimeOptions();
        options.setConsoleWrapper(new JavaConsole());
        options.setJBossHome(System.getenv(JBOSS_HOME_ENV));
        File binFile = new File(options.getJBossHome(), "bin");
        File configFile = new File(binFile, CONFIG_FILE);
        options.setCheckUtil(PasswordCheckUtil.create(configFile));
        if (args.length >= 1) {
            Iterator<String> it = Arrays.asList(args).iterator();
            while (it.hasNext()) {
                String temp = it.next();
                if (CommandLineArgument.HELP.match(temp)) {
                    AddUser.usage(options.getConsoleWrapper());
                    return;
                }
                if (CommandLineArgument.DOMAIN_CONFIG_DIR_USERS.match(temp)) {
                    options.setDomainConfigDir(it.next());
                    continue;
                }
                if (CommandLineArgument.SERVER_CONFIG_DIR_USERS.match(temp)) {
                    options.setServerConfigDir(it.next());
                    continue;
                }
                if (CommandLineArgument.APPLICATION_USERS.match(temp)) {
                    fileMode = FileMode.APPLICATION;
                    continue;
                }
                if (CommandLineArgument.USER_PROPERTIES.match(temp)) {
                    options.setUserProperties(it.next());
                    continue;
                }
                if (CommandLineArgument.GROUP_PROPERTIES.match(temp)) {
                    options.setGroupProperties(it.next());
                    continue;
                }
                CommandLineArgument commandLineArgument = AddUser.findCommandLineOption(temp);
                if (commandLineArgument != null) {
                    String value;
                    if (CommandLineArgument.SILENT.equals((Object)commandLineArgument)) {
                        value = Boolean.TRUE.toString();
                    } else if (CommandLineArgument.CONFIRM_WARNING.equals((Object)commandLineArgument)) {
                        value = Boolean.TRUE.toString();
                    } else if (CommandLineArgument.DISABLE.equals((Object)commandLineArgument)) {
                        value = Boolean.TRUE.toString();
                    } else if (CommandLineArgument.ENABLE.equals((Object)commandLineArgument)) {
                        value = Boolean.TRUE.toString();
                    } else if (CommandLineArgument.DISPLAY_SECRET.equals((Object)commandLineArgument)) {
                        value = Boolean.TRUE.toString();
                    } else {
                        String string = value = it.hasNext() ? it.next() : null;
                    }
                    if (value == null) continue;
                    argsCliProps.setProperty(commandLineArgument.key(), value);
                    continue;
                }
                String userKey = CommandLineArgument.USER.key();
                if (!argsCliProps.containsKey(userKey)) {
                    argsCliProps.setProperty(userKey, temp);
                    continue;
                }
                String passwordKey = CommandLineArgument.PASSWORD.key();
                if (!argsCliProps.containsKey(passwordKey)) {
                    argsCliProps.setProperty(passwordKey, temp);
                    continue;
                }
                String realmKey = CommandLineArgument.REALM.key();
                if (argsCliProps.containsKey(realmKey)) continue;
                argsCliProps.setProperty(realmKey, temp);
            }
        }
        if (argsCliProps.containsKey(CommandLineArgument.CONFIRM_WARNING.key())) {
            options.setConfirmWarning(true);
        }
        if (argsCliProps.containsKey(CommandLineArgument.DISPLAY_SECRET.key())) {
            options.setDisplaySecret(true);
        }
        if (argsCliProps.containsKey(CommandLineArgument.PASSWORD.key()) || argsCliProps.containsKey(CommandLineArgument.USER.key())) {
            String password = argsCliProps.getProperty(CommandLineArgument.PASSWORD.key());
            String user = argsCliProps.getProperty(CommandLineArgument.USER.key());
            boolean enableArgExists = argsCliProps.getProperty(CommandLineArgument.ENABLE.key()) != null;
            boolean disableArgExists = argsCliProps.getProperty(CommandLineArgument.DISABLE.key()) != null;
            boolean disable = Boolean.parseBoolean(argsCliProps.getProperty(CommandLineArgument.DISABLE.key()));
            options.setEnableDisableMode(enableArgExists || disableArgExists);
            options.setDisable(disable);
            if (argsCliProps.containsKey(CommandLineArgument.REALM.key())) {
                new AddUser(options, fileMode, user, password, argsCliProps.getProperty(CommandLineArgument.REALM.key()), RealmMode.USER_SUPPLIED).run();
            } else {
                new AddUser(options, fileMode, user, password).run();
            }
        } else {
            String realm = null;
            if (argsCliProps.containsKey(CommandLineArgument.REALM.key())) {
                realm = argsCliProps.getProperty(CommandLineArgument.REALM.key());
            }
            new AddUser(options, realm).run();
        }
    }

    private static void usage(ConsoleWrapper consoleWrapper) {
        CommandLineArgument.printUsage(consoleWrapper);
    }

    private static CommandLineArgument findCommandLineOption(String arg) {
        for (CommandLineArgument commandLineArgument : CommandLineArgument.values()) {
            if (!commandLineArgument.match(arg)) continue;
            return commandLineArgument;
        }
        return null;
    }

    protected static enum CommandLineArgument {
        APPLICATION_USERS("-a"){

            @Override
            public String instructions() {
                return DomainManagementLogger.ROOT_LOGGER.argApplicationUsers();
            }
        }
        ,
        DOMAIN_CONFIG_DIR_USERS("-dc"){

            @Override
            public String argumentExample() {
                return super.argumentExample().concat(" <value>");
            }

            @Override
            public String instructions() {
                return DomainManagementLogger.ROOT_LOGGER.argDomainConfigDirUsers();
            }
        }
        ,
        SERVER_CONFIG_DIR_USERS("-sc"){

            @Override
            public String argumentExample() {
                return super.argumentExample().concat(" <value>");
            }

            @Override
            public String instructions() {
                return DomainManagementLogger.ROOT_LOGGER.argServerConfigDirUsers();
            }
        }
        ,
        USER_PROPERTIES("-up", "--user-properties"){

            @Override
            public String argumentExample() {
                return super.argumentExample().concat(" <value>");
            }

            @Override
            public String instructions() {
                return DomainManagementLogger.ROOT_LOGGER.argUserProperties();
            }
        }
        ,
        GROUPS("-g", "--group"){

            @Override
            public String argumentExample() {
                return super.argumentExample().concat(" <value>");
            }

            @Override
            public String instructions() {
                return DomainManagementLogger.ROOT_LOGGER.argGroup();
            }
        }
        ,
        GROUP_PROPERTIES("-gp", "--group-properties"){

            @Override
            public String argumentExample() {
                return super.argumentExample().concat(" <value>");
            }

            @Override
            public String instructions() {
                return DomainManagementLogger.ROOT_LOGGER.argGroupProperties();
            }
        }
        ,
        PASSWORD("-p", "--password"){

            @Override
            public String argumentExample() {
                return super.argumentExample().concat(" <value>");
            }

            @Override
            public String instructions() {
                return DomainManagementLogger.ROOT_LOGGER.argPassword();
            }
        }
        ,
        USER("-u", "--user"){

            @Override
            public String argumentExample() {
                return super.argumentExample().concat(" <value>");
            }

            @Override
            public String instructions() {
                return DomainManagementLogger.ROOT_LOGGER.argUser();
            }
        }
        ,
        REALM("-r", "--realm"){

            @Override
            public String argumentExample() {
                return super.argumentExample().concat(" <value>");
            }

            @Override
            public String instructions() {
                return DomainManagementLogger.ROOT_LOGGER.argRealm();
            }
        }
        ,
        SILENT("-s", "--silent", "--silent=true"){

            @Override
            public String instructions() {
                return DomainManagementLogger.ROOT_LOGGER.argSilent();
            }
        }
        ,
        ROLE("-ro", "--role"){

            @Override
            public String argumentExample() {
                return super.argumentExample().concat(" <value>");
            }

            @Override
            public String instructions() {
                return DomainManagementLogger.ROOT_LOGGER.argRole();
            }
        }
        ,
        ENABLE("-e", "--enable"){

            @Override
            public String instructions() {
                return DomainManagementLogger.ROOT_LOGGER.argEnable();
            }
        }
        ,
        DISABLE("-d", "--disable"){

            @Override
            public String instructions() {
                return DomainManagementLogger.ROOT_LOGGER.argDisable();
            }
        }
        ,
        CONFIRM_WARNING("-cw", "--confirm-warning"){

            @Override
            public String instructions() {
                return DomainManagementLogger.ROOT_LOGGER.argConfirmWarning();
            }
        }
        ,
        HELP("-h", "--help"){

            @Override
            public String instructions() {
                return DomainManagementLogger.ROOT_LOGGER.argHelp();
            }
        }
        ,
        DISPLAY_SECRET("-ds", "--display-secret"){

            @Override
            public String instructions() {
                return DomainManagementLogger.ROOT_LOGGER.argDisplaySecret();
            }
        };

        private static String USAGE;
        private String shortArg;
        private String longArg;
        private String additionalArg;

        private CommandLineArgument(String option) {
            this.shortArg = option;
        }

        private CommandLineArgument(String shortArg, String longArg) {
            this.shortArg = shortArg;
            this.longArg = longArg;
        }

        private CommandLineArgument(String shortArg, String longArg, String additionalArg) {
            this.shortArg = shortArg;
            this.longArg = longArg;
            this.additionalArg = additionalArg;
        }

        public String key() {
            return this.longArg != null ? this.longArg.substring(2) : this.shortArg.substring(1);
        }

        public boolean match(String option) {
            return option.equals(this.shortArg) || option.equals(this.longArg) || option.equals(this.additionalArg);
        }

        public String getShortArg() {
            return this.shortArg;
        }

        public String getLongArg() {
            return this.longArg;
        }

        public String argumentExample() {
            return (null != this.getShortArg() ? this.getShortArg() : "").concat((String)(null != this.getLongArg() ? ", " + this.getLongArg() : ""));
        }

        public abstract String instructions();

        public String toString() {
            ArrayList<String> instructions = new ArrayList<String>();
            CommandLineArgument.segmentInstructions(this.instructions(), instructions);
            StringBuilder sb = new StringBuilder(String.format("    %-35s %s", this.argumentExample(), instructions.get(0)));
            for (int i = 1; i < instructions.size(); ++i) {
                sb.append(NEW_LINE);
                sb.append(String.format("%-40s%s", AddUser.SPACE, instructions.get(i)));
            }
            sb.append(NEW_LINE);
            return sb.toString();
        }

        private static void segmentInstructions(String instructions, List<String> segments) {
            if (instructions.length() <= 40) {
                segments.add(instructions);
            } else {
                String testFragment = instructions.substring(0, 40);
                int lastSpace = testFragment.lastIndexOf(32);
                if (lastSpace < 0) {
                    lastSpace = 39;
                }
                segments.add(instructions.substring(0, lastSpace + 1));
                CommandLineArgument.segmentInstructions(instructions.substring(lastSpace + 1), segments);
            }
        }

        public static void printUsage(ConsoleWrapper consoleWrapper) {
            consoleWrapper.printf(CommandLineArgument.usage(), new Object[0]);
        }

        public static String usage() {
            if (USAGE == null) {
                StringBuilder sb = new StringBuilder();
                sb.append(DomainManagementLogger.ROOT_LOGGER.usageDescription()).append(NEW_LINE).append(NEW_LINE);
                sb.append(DomainManagementLogger.ROOT_LOGGER.argUsage()).append(NEW_LINE);
                for (CommandLineArgument arg : CommandLineArgument.values()) {
                    if (arg == ROLE) continue;
                    sb.append(arg.toString()).append(NEW_LINE);
                }
                USAGE = sb.toString();
            }
            return USAGE;
        }
    }

    public static enum FileMode {
        MANAGEMENT,
        APPLICATION,
        UNDEFINED;

    }

    public static enum RealmMode {
        USER_SUPPLIED,
        DEFAULT,
        DISCOVERED;

    }

    public static enum Interactiveness {
        SILENT,
        NON_INTERACTIVE,
        INTERACTIVE;

    }
}

