/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.io;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.io.OptionAttributeDefinition;
import org.xnio.Option;

public class OptionsResourceDefinition
extends PersistentResourceDefinition {
    private final List<OptionAttributeDefinition> attributes;

    private OptionsResourceDefinition(PathElement pathElement, ResourceDescriptionResolver resolver, List<OptionAttributeDefinition> options) {
        super(pathElement, resolver);
        this.attributes = options;
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        if (resourceRegistration.getOperationEntry(PathAddress.EMPTY_ADDRESS, "add") == null) {
            this.registerAddOperation(resourceRegistration, new AbstractAddStepHandler(this.getAttributes()), new OperationEntry.Flag[]{OperationEntry.Flag.RESTART_RESOURCE_SERVICES});
        }
        if (resourceRegistration.getOperationEntry(PathAddress.EMPTY_ADDRESS, "remove") == null) {
            this.registerRemoveOperation(resourceRegistration, (AbstractRemoveStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE, new OperationEntry.Flag[]{OperationEntry.Flag.RESTART_RESOURCE_SERVICES});
        }
    }

    public Collection<AttributeDefinition> getAttributes() {
        return this.attributes;
    }

    public static Builder builder(PathElement pathElement, ResourceDescriptionResolver resolver) {
        return new Builder(pathElement, resolver);
    }

    public static class Builder {
        private final PathElement pathElement;
        private final ResourceDescriptionResolver resolver;
        private List<OptionAttributeDefinition> attributes = new LinkedList<OptionAttributeDefinition>();

        private Builder(PathElement pathElement, ResourceDescriptionResolver resolver) {
            this.pathElement = pathElement;
            this.resolver = resolver;
        }

        public Builder addOption(Option<?> option, String name) {
            this.attributes.add(OptionAttributeDefinition.builder(name, option).build());
            return this;
        }

        public Builder addOption(Option<?> option, String name, ModelNode defaultValue) {
            this.attributes.add(((OptionAttributeDefinition.Builder)OptionAttributeDefinition.builder(name, option).setDefaultValue(defaultValue)).build());
            return this;
        }

        public OptionsResourceDefinition build() {
            return new OptionsResourceDefinition(this.pathElement, this.resolver, this.attributes);
        }
    }
}

