/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.jar.boot;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.concurrent.TimeUnit;

public class CleanupProcessor {
    public static void main(String[] args) throws Exception {
        if (args == null || args.length != 2) {
            throw new IllegalArgumentException("The path to the install directory and number of retires are required.");
        }
        Path installDir = Paths.get(args[0], new String[0]);
        int retries = Integer.parseInt(args[1]);
        Path cleanupMarker = installDir.resolve("wildfly-cleanup-marker");
        for (int attempts = 1; attempts <= retries; ++attempts) {
            boolean lastAttempt = attempts == retries;
            try {
                CleanupProcessor.cleanup(installDir, cleanupMarker, lastAttempt);
                break;
            }
            catch (IOException e) {
                if (lastAttempt) {
                    throw e;
                }
                TimeUnit.MILLISECONDS.sleep(500L);
                continue;
            }
        }
    }

    private static void cleanup(final Path installDir, final Path cleanupMarker, final boolean log) throws IOException {
        Files.walkFileTree(installDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                try {
                    if (!file.equals(cleanupMarker)) {
                        Files.delete(file);
                    }
                }
                catch (IOException e) {
                    if (log) {
                        this.logError("Failed to delete file %s%n\t%s%n", file, e.getLocalizedMessage());
                    }
                    throw e;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                try {
                    if (dir.equals(installDir)) {
                        Files.deleteIfExists(cleanupMarker);
                    }
                    Files.delete(dir);
                }
                catch (IOException e) {
                    if (log) {
                        this.logError("Failed to delete directory %s%n\t%s%n", dir, e.getLocalizedMessage());
                    }
                    throw e;
                }
                return FileVisitResult.CONTINUE;
            }

            private void logError(String format, Object ... args) {
                System.err.printf(format, args);
            }
        });
    }
}

