/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.module;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.modules.AbstractResourceLoader;
import org.jboss.modules.ClassSpec;
import org.jboss.modules.IterableResourceLoader;
import org.jboss.modules.PackageSpec;
import org.jboss.modules.PathUtils;
import org.jboss.modules.Resource;
import org.jboss.modules.filter.PathFilter;
import org.jboss.modules.filter.PathFilters;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;
import org.jboss.vfs.VirtualFilePermission;
import org.jboss.vfs.VirtualFileVisitor;
import org.jboss.vfs.VisitorAttributes;
import org.jboss.vfs.util.FilterVirtualFileVisitor;
import org.wildfly.security.manager.WildFlySecurityManager;

public class VFSResourceLoader
extends AbstractResourceLoader
implements IterableResourceLoader {
    private static final String MR_PREFIX = "META-INF/versions/";
    private static final int RELEASE = Runtime.version().feature();
    private static final Attributes.Name MULTI_RELEASE_NAME = new Attributes.Name("Multi-Release");
    private final VirtualFile root;
    private final String rootName;
    private final Manifest manifest;
    private final URL rootUrl;
    private final boolean multiRelease;
    private final Map<CodeSigners, CodeSource> codeSources = new HashMap<CodeSigners, CodeSource>();
    static final CodeSigners EMPTY_CODE_SIGNERS = new CodeSigners(new CodeSigner[0]);

    public VFSResourceLoader(String rootName, VirtualFile root) throws IOException {
        this(rootName, root, false);
    }

    public VFSResourceLoader(String rootName, final VirtualFile root, boolean usePhysicalCodeSource) throws IOException {
        SecurityManager sm = System.getSecurityManager();
        boolean checking = WildFlySecurityManager.isChecking();
        if (checking) {
            sm.checkPermission((Permission)new VirtualFilePermission(root.getPathName(), "read"));
        }
        this.root = root;
        this.rootName = rootName;
        try {
            this.manifest = checking ? AccessController.doPrivileged(new PrivilegedExceptionAction<Manifest>(){

                @Override
                public Manifest run() throws IOException {
                    return VFSUtils.getManifest((VirtualFile)root);
                }
            }) : VFSUtils.getManifest((VirtualFile)root);
        }
        catch (PrivilegedActionException pe) {
            try {
                throw pe.getException();
            }
            catch (IOException | RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new UndeclaredThrowableException(e);
            }
        }
        this.multiRelease = this.manifest != null && Boolean.parseBoolean(this.manifest.getMainAttributes().getValue(MULTI_RELEASE_NAME));
        this.rootUrl = usePhysicalCodeSource ? VFSUtils.getRootURL((VirtualFile)root) : root.asFileURL();
    }

    VirtualFile getExistentVirtualFile(String name) {
        VirtualFile file;
        if (this.multiRelease) {
            for (int version = RELEASE; version >= 9; --version) {
                file = this.root.getChild(MR_PREFIX + version + "/" + name);
                if (!file.exists()) continue;
                return file;
            }
        }
        return (file = this.root.getChild(name)).exists() ? file : null;
    }

    public boolean isMultiRelease() {
        return this.multiRelease;
    }

    public ClassSpec getClassSpec(final String name) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<ClassSpec>(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public ClassSpec run() throws Exception {
                    VirtualFile file = VFSResourceLoader.this.getExistentVirtualFile(name);
                    if (file == null) {
                        return null;
                    }
                    long size = file.getSize();
                    ClassSpec spec = new ClassSpec();
                    VFSResourceLoader vFSResourceLoader = VFSResourceLoader.this;
                    synchronized (vFSResourceLoader) {
                        InputStream is = file.openStream();
                        try {
                            if (size <= Integer.MAX_VALUE) {
                                int res;
                                int castSize = (int)size;
                                byte[] bytes = new byte[castSize];
                                int a = 0;
                                while ((res = is.read(bytes, a, castSize - a)) > 0) {
                                    a += res;
                                }
                                while (is.read() != -1) {
                                }
                                is.close();
                                spec.setBytes(bytes);
                                CodeSigner[] entryCodeSigners = file.getCodeSigners();
                                CodeSigners codeSigners = entryCodeSigners == null || entryCodeSigners.length == 0 ? EMPTY_CODE_SIGNERS : new CodeSigners(entryCodeSigners);
                                CodeSource codeSource = VFSResourceLoader.this.codeSources.get(codeSigners);
                                if (codeSource == null) {
                                    codeSource = new CodeSource(VFSResourceLoader.this.rootUrl, entryCodeSigners);
                                    VFSResourceLoader.this.codeSources.put(codeSigners, codeSource);
                                }
                                spec.setCodeSource(codeSource);
                                ClassSpec classSpec = spec;
                                return classSpec;
                            }
                            throw ServerLogger.ROOT_LOGGER.resourceTooLarge();
                        }
                        finally {
                            VFSUtils.safeClose((Closeable)is);
                        }
                    }
                }
            });
        }
        catch (PrivilegedActionException pe) {
            try {
                throw pe.getException();
            }
            catch (IOException | Error | RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new UndeclaredThrowableException(e);
            }
        }
    }

    public PackageSpec getPackageSpec(String name) throws IOException {
        return VFSResourceLoader.getPackageSpec((String)name, (Manifest)this.manifest, (URL)this.rootUrl);
    }

    public String getLibrary(String name) {
        return null;
    }

    public String getRootName() {
        return this.rootName;
    }

    public PathFilter getExportFilter() {
        return PathFilters.acceptAll();
    }

    public Resource getResource(final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<Resource>(){

            @Override
            public Resource run() {
                try {
                    VirtualFile file = VFSResourceLoader.this.getExistentVirtualFile(PathUtils.canonicalize((String)name));
                    if (file == null) {
                        return null;
                    }
                    return new VFSEntryResource(file.getPathNameRelativeTo(VFSResourceLoader.this.root), file, file.toURL());
                }
                catch (MalformedURLException e) {
                    return null;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getPaths() {
        ArrayList<String> index = new ArrayList<String>();
        VirtualFile indexFile = VFS.getChild((String)(this.root.getPathName() + ".index"));
        if (indexFile.exists()) {
            ArrayList<String> arrayList;
            BufferedReader r = new BufferedReader(new InputStreamReader(indexFile.openStream(), StandardCharsets.UTF_8));
            try {
                String s;
                while ((s = r.readLine()) != null) {
                    index.add(s.trim());
                }
                arrayList = index;
            }
            catch (Throwable throwable) {
                try {
                    r.close();
                    throw throwable;
                }
                catch (IOException e) {
                    index.clear();
                }
            }
            r.close();
            return arrayList;
        }
        FilterVirtualFileVisitor visitor = new FilterVirtualFileVisitor(new VirtualFileFilter(){

            public boolean accepts(VirtualFile file) {
                return file.isDirectory();
            }
        }, VisitorAttributes.RECURSE);
        try {
            this.root.visit((VirtualFileVisitor)visitor);
        }
        catch (IOException e) {
            index.clear();
        }
        index.add("");
        for (VirtualFile dir : visitor.getMatched()) {
            index.add(dir.getPathNameRelativeTo(this.root));
        }
        return index;
    }

    public Iterator<Resource> iterateResources(String startPath, boolean recursive) {
        Iterator children;
        VirtualFile child = this.root.getChild(startPath);
        if (startPath.length() > 1 && child == this.root) {
            return Collections.emptySet().iterator();
        }
        VirtualFileFilter filter = new VirtualFileFilter(){

            public boolean accepts(VirtualFile file) {
                return file.isFile();
            }
        };
        try {
            children = (recursive ? child.getChildrenRecursively(filter) : child.getChildren(filter)).iterator();
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        return new Iterator<Resource>(){

            @Override
            public boolean hasNext() {
                return children.hasNext();
            }

            @Override
            public Resource next() {
                URL fileURL;
                VirtualFile file = (VirtualFile)children.next();
                try {
                    fileURL = file.toURL();
                }
                catch (MalformedURLException ex) {
                    throw new IllegalStateException(ex);
                }
                return new VFSEntryResource(file.getPathNameRelativeTo(VFSResourceLoader.this.root), file, fileURL);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    static final class CodeSigners {
        private final CodeSigner[] codeSigners;
        private final int hashCode;

        public CodeSigners(CodeSigner[] codeSigners) {
            this.codeSigners = codeSigners;
            this.hashCode = Arrays.hashCode(codeSigners);
        }

        public boolean equals(Object obj) {
            return obj instanceof CodeSigners && this.equals((CodeSigners)obj);
        }

        private boolean equals(CodeSigners other) {
            return Arrays.equals(this.codeSigners, other.codeSigners);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    static class VFSEntryResource
    implements Resource {
        private final String name;
        private final VirtualFile entry;
        private final URL resourceURL;

        VFSEntryResource(String name, VirtualFile entry, URL resourceURL) {
            this.name = name;
            this.entry = entry;
            this.resourceURL = resourceURL;
        }

        public String getName() {
            return this.name;
        }

        public URL getURL() {
            return this.resourceURL;
        }

        public InputStream openStream() throws IOException {
            return this.entry.openStream();
        }

        public long getSize() {
            long size = this.entry.getSize();
            return size == -1L ? 0L : size;
        }
    }
}

