/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.subsystem.service;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.RequirementServiceBuilder;
import org.jboss.as.controller.RequirementServiceTarget;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.common.function.Functions;
import org.wildfly.service.AsyncServiceBuilder;
import org.wildfly.service.Installer;
import org.wildfly.subsystem.service.AsyncServiceBuilder;
import org.wildfly.subsystem.service.DeploymentServiceInstaller;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;

public interface ServiceInstaller
extends ResourceServiceInstaller,
DeploymentServiceInstaller,
Installer<RequirementServiceTarget> {
    public static <V> Builder<V, V> builder(V value) {
        return (Builder)ServiceInstaller.builder(Functions.constantSupplier(value)).asActive();
    }

    public static <V> Builder<V, V> builder(ServiceDependency<V> dependency) {
        return (Builder)((Builder)ServiceInstaller.builder(dependency).withDependency((Consumer)((Object)dependency))).asPassive();
    }

    public static <V> Builder<V, V> builder(Supplier<V> factory) {
        return ServiceInstaller.builder(Function.identity(), factory);
    }

    public static <T, V> Builder<T, V> builder(Function<T, V> mapper, Supplier<T> factory) {
        return new DefaultServiceInstaller.Builder<T, V>(mapper, factory);
    }

    @Override
    default public Consumer<OperationContext> install(OperationContext context) {
        final ServiceController controller = this.install((ServiceTarget)context.getCapabilityServiceTarget());
        return new Consumer<OperationContext>(){

            @Override
            public void accept(OperationContext context) {
                context.removeService(controller);
            }
        };
    }

    @Override
    default public void install(DeploymentPhaseContext context) {
        this.install((ServiceTarget)context.getRequirementServiceTarget());
    }

    public static class DefaultServiceInstaller<T, V>
    extends Installer.AbstractInstaller<RequirementServiceTarget, RequirementServiceBuilder<?>, RequirementServiceBuilder<?>, T, V>
    implements ServiceInstaller {
        private static final Function<RequirementServiceTarget, RequirementServiceBuilder<?>> FACTORY = RequirementServiceTarget::addService;

        DefaultServiceInstaller(Installer.Configuration<RequirementServiceBuilder<?>, RequirementServiceBuilder<?>, T, V> config) {
            super(config, FACTORY);
        }

        static class Builder<T, V>
        extends Installer.AbstractInstaller.Builder<org.wildfly.subsystem.service.ServiceInstaller$Builder<T, V>, ServiceInstaller, RequirementServiceTarget, RequirementServiceBuilder<?>, RequirementServiceBuilder<?>, T, V>
        implements org.wildfly.subsystem.service.ServiceInstaller$Builder<T, V> {
            private volatile boolean sync = true;
            private volatile AsyncServiceBuilder.Async async = AsyncServiceBuilder.Async.START_ONLY;

            Builder(Function<T, V> mapper, Supplier<T> factory) {
                super(mapper, factory);
            }

            @Override
            public org.wildfly.subsystem.service.ServiceInstaller$Builder<T, V> async() {
                this.sync = false;
                return this;
            }

            public org.wildfly.subsystem.service.ServiceInstaller$Builder<T, V> onStop(Consumer<T> consumer) {
                this.async = AsyncServiceBuilder.Async.START_AND_STOP;
                return (org.wildfly.subsystem.service.ServiceInstaller$Builder)super.onStop(consumer);
            }

            public UnaryOperator<RequirementServiceBuilder<?>> getServiceBuilderDecorator() {
                final AsyncServiceBuilder.Async async = this.async;
                return this.sync ? UnaryOperator.identity() : new UnaryOperator<RequirementServiceBuilder<?>>(){

                    @Override
                    public RequirementServiceBuilder<?> apply(RequirementServiceBuilder<?> builder) {
                        return new AsyncServiceBuilder(builder, async);
                    }
                };
            }

            public ServiceInstaller build() {
                return new DefaultServiceInstaller(this);
            }

            protected org.wildfly.subsystem.service.ServiceInstaller$Builder<T, V> builder() {
                return this;
            }
        }
    }

    public static interface Builder<T, V>
    extends Installer.Builder<Builder<T, V>, ServiceInstaller, RequirementServiceTarget, RequirementServiceBuilder<?>, T, V> {
        public Builder<T, V> async();
    }
}

