/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.transformer;

import java.util.Iterator;
import java.util.ServiceLoader;
import org.wildfly.extras.transformer.TransformerBuilder;

public abstract class TransformerFactory {
    private static final TransformerFactory INSTANCE;

    public static TransformerFactory getInstance() {
        return INSTANCE;
    }

    public abstract TransformerBuilder newTransformer();

    static {
        Iterator<TransformerFactory> i = ServiceLoader.load(TransformerFactory.class, TransformerFactory.class.getClassLoader()).iterator();
        TransformerFactory factoryImpl = null;
        while (i.hasNext() && (factoryImpl = i.next()) == null) {
        }
        if (factoryImpl == null) {
            throw new IllegalStateException("Service provider for " + TransformerFactory.class.getName() + " not found");
        }
        INSTANCE = factoryImpl;
    }
}

