/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.maven;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nu.xom.Attribute;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.ParsingException;
import org.wildfly.galleon.maven.ModuleIdentifier;
import org.wildfly.galleon.maven.ModuleParseResult;

class ModuleXmlParser {
    private static final Pattern JBOSS_MODULES_VALID_PATTERN = Pattern.compile("^([-_a-zA-Z0-9.]+):([-_a-zA-Z0-9.]+):([-_a-zA-Z0-9.]+)(?::([-_a-zA-Z0-9.]+))?$");

    ModuleXmlParser() {
    }

    static ModuleParseResult parse(Path file, String encoding, Map<ModuleIdentifier, Set<ModuleIdentifier>> targetToAlias) throws IOException, ParsingException {
        try (BufferedReader is = Files.newBufferedReader(file, Charset.forName(encoding));){
            ModuleParseResult moduleParseResult = ModuleXmlParser.parse(is, targetToAlias);
            return moduleParseResult;
        }
    }

    static void populateAlias(Path file, String encoding, Map<ModuleIdentifier, Set<ModuleIdentifier>> targetToAlias) throws IOException, ParsingException {
        try (BufferedReader is = Files.newBufferedReader(file, Charset.forName(encoding));){
            ModuleXmlParser.populateAlias(is, targetToAlias);
        }
    }

    private static void populateAlias(Reader r, Map<ModuleIdentifier, Set<ModuleIdentifier>> targetToAlias) throws IOException, ParsingException {
        Builder builder = new Builder(false);
        Document document = builder.build(r);
        ModuleParseResult result = new ModuleParseResult(document);
        Element rootElement = document.getRootElement();
        if (rootElement.getLocalName().equals("module-alias")) {
            ModuleXmlParser.populateModuleAlias(rootElement, targetToAlias);
        }
    }

    private static void populateModuleAlias(Element element, Map<ModuleIdentifier, Set<ModuleIdentifier>> targetToAlias) {
        String targetName = ModuleXmlParser.getOptionalAttributeValue(element, "target-name", "");
        String targetSlot = ModuleXmlParser.getOptionalAttributeValue(element, "target-slot", "main");
        String name = element.getAttributeValue("name");
        ModuleIdentifier targetModuleId = ModuleXmlParser.getModuleIdentifier(targetName, targetSlot);
        Set<ModuleIdentifier> aliases = targetToAlias.get(targetModuleId);
        if (aliases == null) {
            aliases = new HashSet<ModuleIdentifier>();
            targetToAlias.put(targetModuleId, aliases);
        }
        String slot = ModuleXmlParser.getOptionalAttributeValue(element, "slot", "main");
        ModuleIdentifier aliasModuleId = ModuleXmlParser.getModuleIdentifier(name, slot);
        aliases.add(aliasModuleId);
    }

    private static ModuleIdentifier getModuleIdentifier(String name, String slot) {
        ModuleIdentifier moduleId = name.indexOf(58) < 0 ? new ModuleIdentifier(name, slot) : ModuleIdentifier.fromString(name);
        return moduleId;
    }

    private static ModuleParseResult parse(Reader r, Map<ModuleIdentifier, Set<ModuleIdentifier>> targetToAlias) throws IOException, ParsingException {
        Builder builder = new Builder(false);
        Document document = builder.build(r);
        ModuleParseResult result = new ModuleParseResult(document);
        Element rootElement = document.getRootElement();
        if (rootElement.getLocalName().equals("module-alias")) {
            ModuleXmlParser.parseModuleAlias(rootElement, result);
        } else if (rootElement.getLocalName().equals("module")) {
            ModuleXmlParser.parseModule(rootElement, result, targetToAlias);
        }
        return result;
    }

    private static void parseModule(Element element, ModuleParseResult result, Map<ModuleIdentifier, Set<ModuleIdentifier>> targetToAlias) throws ParsingException {
        Set<ModuleIdentifier> aliases;
        Element resources;
        Element dependencies;
        Element props;
        String name = element.getAttributeValue("name");
        String slot = ModuleXmlParser.getOptionalAttributeValue(element, "slot", "main");
        result.identifier = ModuleXmlParser.getModuleIdentifier(name, slot);
        Attribute versionAttribute = element.getAttribute("version");
        if (versionAttribute != null) {
            result.versionArtifactName = ModuleXmlParser.parseOptionalArtifactName(versionAttribute.getValue(), versionAttribute);
        }
        if ((props = element.getFirstChildElement("properties", element.getNamespaceURI())) != null) {
            Map<String, String> properties = ModuleXmlParser.parseProperties(props);
            result.getProperties().putAll(properties);
        }
        if ((dependencies = element.getFirstChildElement("dependencies", element.getNamespaceURI())) != null) {
            ModuleXmlParser.parseDependencies(dependencies, result);
        }
        if ((resources = element.getFirstChildElement("resources", element.getNamespaceURI())) != null) {
            ModuleXmlParser.parseResources(resources, result);
        }
        if ((aliases = targetToAlias.get(result.identifier)) != null) {
            for (ModuleIdentifier alias : aliases) {
                result.dependencies.add(new ModuleParseResult.ModuleDependency(alias, false, Collections.emptyMap()));
            }
        }
    }

    private static String getOptionalAttributeValue(Element element, String name, String defVal) {
        String value = element.getAttributeValue(name);
        return value == null ? defVal : value;
    }

    private static void parseModuleAlias(Element element, ModuleParseResult result) {
        String targetName = ModuleXmlParser.getOptionalAttributeValue(element, "target-name", "");
        String targetSlot = ModuleXmlParser.getOptionalAttributeValue(element, "target-slot", "main");
        String name = element.getAttributeValue("name");
        String slot = ModuleXmlParser.getOptionalAttributeValue(element, "slot", "main");
        ModuleIdentifier moduleId = ModuleXmlParser.getModuleIdentifier(targetName, targetSlot);
        result.identifier = ModuleXmlParser.getModuleIdentifier(name, slot);
        result.dependencies.add(new ModuleParseResult.ModuleDependency(moduleId, false, Collections.emptyMap()));
    }

    private static void parseDependencies(Element element, ModuleParseResult result) throws ParsingException {
        Elements modules = element.getChildElements("module", element.getNamespaceURI());
        int size = modules.size();
        for (int i = 0; i < size; ++i) {
            Element moduleElement = modules.get(i);
            String name = ModuleXmlParser.getOptionalAttributeValue(moduleElement, "name", "");
            String slot = ModuleXmlParser.getOptionalAttributeValue(moduleElement, "slot", "main");
            ModuleIdentifier moduleId = ModuleXmlParser.getModuleIdentifier(name, slot);
            boolean optional = Boolean.parseBoolean(ModuleXmlParser.getOptionalAttributeValue(moduleElement, "optional", "false"));
            Element properties = moduleElement.getFirstChildElement("properties", moduleElement.getNamespaceURI());
            Map<String, String> props = properties != null ? ModuleXmlParser.parseProperties(properties) : Collections.emptyMap();
            result.dependencies.add(new ModuleParseResult.ModuleDependency(moduleId, optional, props));
        }
    }

    private static Map<String, String> parseProperties(Element element) throws ParsingException {
        Elements properties = element.getChildElements("property", element.getNamespaceURI());
        int size = properties.size();
        if (size == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, String> props = new HashMap<String, String>(size);
        for (int i = 0; i < size; ++i) {
            Element propertyElement = properties.get(i);
            String name = propertyElement.getAttributeValue("name");
            if (name == null) {
                throw new ParsingException("Element property is missing required attribute name");
            }
            String value = propertyElement.getAttributeValue("value");
            if (value == null) {
                throw new ParsingException("Element property is missing required attribute value");
            }
            props.put(name, value);
        }
        return Collections.unmodifiableMap(props);
    }

    private static void parseResources(Element element, ModuleParseResult result) {
        Elements children = element.getChildElements();
        int size = children.size();
        block8: for (int i = 0; i < size; ++i) {
            Element child = children.get(i);
            switch (child.getLocalName()) {
                case "resource-root": {
                    String path = child.getAttributeValue("path");
                    if (path == null) continue block8;
                    result.resourceRoots.add(path);
                    continue block8;
                }
                case "artifact": {
                    Attribute attribute = child.getAttribute("name");
                    if (attribute == null) continue block8;
                    String nameStr = attribute.getValue();
                    result.artifacts.add(ModuleXmlParser.parseArtifactName(nameStr, attribute));
                    continue block8;
                }
            }
        }
    }

    private static ModuleParseResult.ArtifactName parseArtifactName(String artifactName, Attribute attribute) {
        ModuleParseResult.ArtifactName name = ModuleXmlParser.parseOptionalArtifactName(artifactName, attribute);
        if (name == null) {
            Matcher matcher = JBOSS_MODULES_VALID_PATTERN.matcher(artifactName);
            if (matcher.matches()) {
                StringBuilder sb = new StringBuilder();
                sb.append(matcher.group(1)).append(":").append(matcher.group(2)).append("::");
                if (matcher.group(4) != null) {
                    sb.append(matcher.group(4));
                }
                sb.append(":").append(matcher.group(3));
                return new ModuleParseResult.ArtifactName(sb.toString(), null, attribute);
            }
            throw new RuntimeException("Hard coded artifact " + artifactName);
        }
        return name;
    }

    private static ModuleParseResult.ArtifactName parseOptionalArtifactName(String artifactName, Attribute attribute) {
        if (artifactName.startsWith("${") && artifactName.endsWith("}")) {
            String ct = artifactName.substring(2, artifactName.length() - 1);
            String options = null;
            String artifactCoords = ct;
            if (ct.contains("?")) {
                String[] split = ct.split("\\?");
                options = split[1];
                artifactCoords = split[0];
            }
            return new ModuleParseResult.ArtifactName(artifactCoords, options, attribute);
        }
        return null;
    }
}

