/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.maven;

import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.wildfly.galleon.plugin.ArtifactCoords;

public class ModuleXmlVersionResolver {
    private static XMLOutputFactory XML_OUTPUT_FACTORY;
    private static XMLInputFactory XML_INPUT_FACTORY;

    private static XMLOutputFactory getXmlOutputFactory() {
        return XML_OUTPUT_FACTORY == null ? (XML_OUTPUT_FACTORY = XMLOutputFactory.newInstance()) : XML_OUTPUT_FACTORY;
    }

    private static XMLInputFactory getXmlInputFactory() {
        return XML_INPUT_FACTORY == null ? (XML_INPUT_FACTORY = XMLInputFactory.newInstance()) : XML_INPUT_FACTORY;
    }

    public static void convertModule(Path file, Path target, Map<String, Artifact> artifacts, List<Artifact> hardcodedArtifacts, Log log) throws IOException, XMLStreamException, MojoExecutionException {
        Files.deleteIfExists(target);
        Files.createDirectories(target.getParent(), new FileAttribute[0]);
        try (BufferedReader is = Files.newBufferedReader(file, Charsets.UTF_8);
             BufferedWriter out = Files.newBufferedWriter(target, Charsets.UTF_8, StandardOpenOption.CREATE_NEW);){
            ModuleXmlVersionResolver.convert(ModuleXmlVersionResolver.getXmlInputFactory().createXMLEventReader(is), ModuleXmlVersionResolver.getXmlOutputFactory().createXMLEventWriter(out), artifacts, hardcodedArtifacts, log);
        }
    }

    private static void convert(XMLEventReader r, XMLEventWriter w, Map<String, Artifact> artifacts, List<Artifact> hardcodedArtifacts, Log log) throws IOException, XMLStreamException, MojoExecutionException {
        XMLEventFactory eventFactory = XMLEventFactory.newInstance();
        while (r.hasNext()) {
            XMLEvent event = r.nextEvent();
            switch (event.getEventType()) {
                case 1: {
                    StartElement startElement = event.asStartElement();
                    if ("module".equals(startElement.getName().getLocalPart())) {
                        StartElement convertedModule = ModuleXmlVersionResolver.convertModuleElement(eventFactory, startElement, artifacts);
                        log.debug((CharSequence)(startElement + " has been converted to " + convertedModule));
                        w.add(convertedModule);
                        break;
                    }
                    if ("artifact".equals(startElement.getName().getLocalPart())) {
                        StartElement convertedArtifact = ModuleXmlVersionResolver.convertArtifactElement(eventFactory, startElement, artifacts, hardcodedArtifacts, log);
                        log.debug((CharSequence)(startElement + " has been converted to " + convertedArtifact));
                        w.add(convertedArtifact);
                        break;
                    }
                    w.add(event);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 12: 
                case 13: {
                    w.add(event);
                }
            }
        }
        w.flush();
        w.close();
    }

    private static StartElement convertArtifactElement(XMLEventFactory eventFactory, StartElement artifactElement, Map<String, Artifact> artifacts, List<Artifact> hardcodedArtifacts, Log log) throws MojoExecutionException {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        Iterator<Attribute> iter = artifactElement.getAttributes();
        while (iter.hasNext()) {
            Attribute attribute = iter.next();
            if ("name".equals(attribute.getName().getLocalPart())) {
                String artifactName = attribute.getValue();
                String artifactCoords = ModuleXmlVersionResolver.getArtifactCoordinates(artifactName);
                if (artifactCoords != null) {
                    Artifact artifact = artifacts.get(artifactCoords);
                    if (artifact == null) {
                        throw new MojoExecutionException("Couldn't locate artifact in the dependencies " + artifactCoords);
                    }
                    StringJoiner joiner = new StringJoiner(":");
                    joiner.add(artifact.getGroupId());
                    joiner.add(artifact.getArtifactId());
                    joiner.add(artifact.getVersion());
                    if (artifact.hasClassifier()) {
                        joiner.add(artifact.getClassifier());
                    }
                    attributes.add(eventFactory.createAttribute(attribute.getName(), joiner.toString()));
                    continue;
                }
                attributes.add(attribute);
                ArtifactCoords coords = ArtifactCoords.fromString((String)artifactName);
                hardcodedArtifacts.add((Artifact)new DefaultArtifact(coords.getGroupId(), coords.getArtifactId(), coords.getVersion(), "provided", coords.getExtension(), coords.getClassifier(), (ArtifactHandler)new DefaultArtifactHandler(coords.getExtension())));
                continue;
            }
            attributes.add(attribute);
        }
        return eventFactory.createStartElement(artifactElement.getName(), attributes.iterator(), artifactElement.getNamespaces());
    }

    private static StartElement convertModuleElement(XMLEventFactory eventFactory, StartElement module, Map<String, Artifact> artifacts) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        Iterator<Attribute> iter = module.getAttributes();
        while (iter.hasNext()) {
            Attribute attribute = iter.next();
            if ("version".equals(attribute.getName().getLocalPart())) {
                String artifactName = attribute.getValue();
                String artifactCoords = ModuleXmlVersionResolver.getArtifactCoordinates(artifactName);
                if (artifactCoords != null) {
                    attributes.add(eventFactory.createAttribute("version", artifacts.get(artifactCoords).getVersion()));
                    continue;
                }
                attributes.add(attribute);
                continue;
            }
            attributes.add(attribute);
        }
        return eventFactory.createStartElement(module.getName(), attributes.iterator(), module.getNamespaces());
    }

    private static String getArtifactCoordinates(String artifactName) {
        String artifactCoords = null;
        if (artifactName.startsWith("${") && artifactName.endsWith("}")) {
            String ct = artifactName.substring(2, artifactName.length() - 1);
            if (ct.contains("?")) {
                String[] split = ct.split("\\?");
                artifactCoords = split[0];
            } else {
                artifactCoords = ct;
            }
        }
        return artifactCoords;
    }

    static void addHardCodedArtifacts(Path file, Set<String> hardcodedArtifacts) throws IOException, XMLStreamException {
        try (BufferedReader is = Files.newBufferedReader(file, Charsets.UTF_8);){
            ModuleXmlVersionResolver.addHardCodedArtifacts(ModuleXmlVersionResolver.getXmlInputFactory().createXMLEventReader(is), hardcodedArtifacts);
        }
    }

    private static void addHardCodedArtifacts(XMLEventReader r, Set<String> hardcodedArtifacts) throws IOException, XMLStreamException {
        while (r.hasNext()) {
            XMLEvent event = r.nextEvent();
            switch (event.getEventType()) {
                case 1: {
                    StartElement startElement = event.asStartElement();
                    if (!"artifact".equals(startElement.getName().getLocalPart())) break;
                    ModuleXmlVersionResolver.addHardCodedArtifacts(startElement, hardcodedArtifacts);
                }
            }
        }
    }

    private static void addHardCodedArtifacts(StartElement artifactElement, Set<String> hardcodedArtifacts) {
        Iterator<Attribute> iter = artifactElement.getAttributes();
        while (iter.hasNext()) {
            String artifactName;
            String artifactCoords;
            Attribute attribute = iter.next();
            if (!"name".equals(attribute.getName().getLocalPart()) || (artifactCoords = ModuleXmlVersionResolver.getArtifactCoordinates(artifactName = attribute.getValue())) != null) continue;
            ArtifactCoords coords = ArtifactCoords.fromString((String)artifactName);
            StringBuilder buf = new StringBuilder(coords.getGroupId()).append(':').append(coords.getArtifactId()).append(':').append(coords.getVersion()).append(':');
            String classifier = coords.getClassifier();
            if (classifier != null && !classifier.isEmpty()) {
                buf.append(classifier);
            }
            buf.append(':').append(coords.getExtension());
            hardcodedArtifacts.add(buf.toString());
        }
    }
}

