/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ArtifactCoords
implements Comparable<ArtifactCoords> {
    private static final Pattern COORDS_PATTERN = Pattern.compile("([^: ]+):([^: ]+)(:([^: ]*)(:([^: ]+))?)?:([^: ]+)");
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String classifier;
    private final String extension;
    private final Gav gavPart;
    private final Ga gaPart;

    public static ArtifactCoords newInstance(String groupId, String artifactId, String version, String extension) {
        return new ArtifactCoords(groupId, artifactId, version, null, extension);
    }

    public static ArtifactCoords fromGav(Gav gav, String extension) {
        return new ArtifactCoords(gav.getGroupId(), gav.getArtifactId(), gav.getVersion(), null, extension);
    }

    public static ArtifactCoords fromString(String str) {
        return new ArtifactCoords(str, "jar");
    }

    public static ArtifactCoords fromString(String str, String defaultExtension) {
        return new ArtifactCoords(str, defaultExtension);
    }

    public static Gav newGav(String groupId, String artifactId, String version) {
        return new ArtifactCoords(groupId, artifactId, version, "", "zip").toGav();
    }

    public static Gav newGav(String str) {
        String version;
        String artifactId;
        int i = str.indexOf(58);
        if (i <= 0) {
            throw new IllegalArgumentException("groupId is missing in '" + str + "'");
        }
        String groupId = str.substring(0, i);
        if ((i = str.indexOf(58, i + 1)) < 0) {
            artifactId = str.substring(groupId.length() + 1);
            version = null;
        } else {
            artifactId = str.substring(groupId.length() + 1, i);
            version = str.substring(i + 1);
        }
        return ArtifactCoords.newGav(groupId, artifactId, version);
    }

    public static Ga newGa(String groupId, String artifactId) {
        return new ArtifactCoords(groupId, artifactId, null, "", "zip").toGa();
    }

    private static String get(String value, String defaultValue) {
        return value == null || value.length() <= 0 ? defaultValue : value;
    }

    private ArtifactCoords(String str, String defaultExtension) {
        Matcher m = COORDS_PATTERN.matcher(str);
        if (!m.matches()) {
            throw new IllegalArgumentException("Bad artifact coordinates " + str + ", expected format is <groupId>:<artifactId>[:<extension>[:<classifier>]]:<version>");
        }
        this.groupId = m.group(1);
        this.artifactId = m.group(2);
        this.extension = ArtifactCoords.get(m.group(4), defaultExtension);
        this.classifier = ArtifactCoords.get(m.group(6), "");
        this.version = m.group(7);
        this.gavPart = new Gav();
        this.gaPart = new Ga();
    }

    public ArtifactCoords(String groupId, String artifactId, String version, String classifier, String extension) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.classifier = ArtifactCoords.get(classifier, "");
        this.extension = ArtifactCoords.get(extension, "jar");
        this.gavPart = new Gav();
        this.gaPart = new Ga();
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getExtension() {
        return this.extension;
    }

    public Gav toGav() {
        return this.gavPart;
    }

    public Ga toGa() {
        return this.gaPart;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.artifactId == null ? 0 : this.artifactId.hashCode());
        result = 31 * result + (this.classifier == null ? 0 : this.classifier.hashCode());
        result = 31 * result + (this.extension == null ? 0 : this.extension.hashCode());
        result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArtifactCoords other = (ArtifactCoords)obj;
        if (this.artifactId == null ? other.artifactId != null : !this.artifactId.equals(other.artifactId)) {
            return false;
        }
        if (this.classifier == null ? other.classifier != null : !this.classifier.equals(other.classifier)) {
            return false;
        }
        if (this.extension == null ? other.extension != null : !this.extension.equals(other.extension)) {
            return false;
        }
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    @Override
    public int compareTo(ArtifactCoords o) {
        int result = this.groupId.compareTo(o.groupId);
        if (result != 0) {
            return result;
        }
        result = this.artifactId.compareTo(o.artifactId);
        if (result != 0) {
            return result;
        }
        if (this.classifier != null) {
            result = o.classifier == null ? 1 : this.classifier.compareTo(o.classifier);
        } else if (o.classifier != null) {
            result = -1;
        }
        if (result != 0) {
            return result;
        }
        if (this.extension != null) {
            result = o.extension == null ? 1 : this.extension.compareTo(o.extension);
        } else if (o.extension != null) {
            result = -1;
        }
        if (result != 0) {
            return result;
        }
        if (this.version != null) {
            result = o.version == null ? 1 : this.version.compareTo(o.version);
        } else if (o.version != null) {
            result = -1;
        }
        return result;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.groupId).append(':').append(this.artifactId);
        if (this.extension != null) {
            buf.append(':').append(this.extension);
        }
        if (!this.classifier.isEmpty()) {
            buf.append(':').append(this.classifier);
        }
        if (this.version != null) {
            buf.append(':').append(this.version);
        }
        return buf.toString();
    }

    public class Ga
    implements Comparable<Ga> {
        public String getGroupId() {
            return ArtifactCoords.this.groupId;
        }

        public String getArtifactId() {
            return ArtifactCoords.this.artifactId;
        }

        public Gav toGav() {
            return ArtifactCoords.this.toGav();
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            if (ArtifactCoords.this.groupId != null) {
                buf.append(ArtifactCoords.this.groupId);
            }
            buf.append(':');
            if (ArtifactCoords.this.artifactId != null) {
                buf.append(ArtifactCoords.this.artifactId);
            }
            return buf.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (ArtifactCoords.this.artifactId == null ? 0 : ArtifactCoords.this.artifactId.hashCode());
            result = 31 * result + (ArtifactCoords.this.groupId == null ? 0 : ArtifactCoords.this.groupId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Ga other = (Ga)obj;
            if (ArtifactCoords.this.artifactId == null ? other.getArtifactId() != null : !ArtifactCoords.this.artifactId.equals(other.getArtifactId())) {
                return false;
            }
            return !(ArtifactCoords.this.groupId == null ? other.getGroupId() != null : !ArtifactCoords.this.groupId.equals(other.getGroupId()));
        }

        @Override
        public int compareTo(Ga o) {
            if (o == null) {
                return 1;
            }
            int i = ArtifactCoords.this.groupId.compareTo(o.getGroupId());
            if (i != 0) {
                return i;
            }
            return ArtifactCoords.this.artifactId.compareTo(o.getArtifactId());
        }
    }

    public class Gav
    implements Comparable<Gav> {
        public String getGroupId() {
            return ArtifactCoords.this.groupId;
        }

        public String getArtifactId() {
            return ArtifactCoords.this.artifactId;
        }

        public String getVersion() {
            return ArtifactCoords.this.version;
        }

        public ArtifactCoords toArtifactCoords() {
            return ArtifactCoords.this;
        }

        public Ga toGa() {
            return ArtifactCoords.this.toGa();
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            if (ArtifactCoords.this.groupId != null) {
                buf.append(ArtifactCoords.this.groupId);
            }
            buf.append(':');
            if (ArtifactCoords.this.artifactId != null) {
                buf.append(ArtifactCoords.this.artifactId);
            }
            if (ArtifactCoords.this.version != null) {
                buf.append(':').append(ArtifactCoords.this.version);
            }
            return buf.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (ArtifactCoords.this.artifactId == null ? 0 : ArtifactCoords.this.artifactId.hashCode());
            result = 31 * result + (ArtifactCoords.this.groupId == null ? 0 : ArtifactCoords.this.groupId.hashCode());
            result = 31 * result + (ArtifactCoords.this.version == null ? 0 : ArtifactCoords.this.version.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Gav other = (Gav)obj;
            if (ArtifactCoords.this.artifactId == null ? other.getArtifactId() != null : !ArtifactCoords.this.artifactId.equals(other.getArtifactId())) {
                return false;
            }
            if (ArtifactCoords.this.groupId == null ? other.getGroupId() != null : !ArtifactCoords.this.groupId.equals(other.getGroupId())) {
                return false;
            }
            return !(ArtifactCoords.this.version == null ? other.getVersion() != null : !ArtifactCoords.this.version.equals(other.getVersion()));
        }

        @Override
        public int compareTo(Gav o) {
            if (o == null) {
                return 1;
            }
            int i = ArtifactCoords.this.groupId.compareTo(o.getGroupId());
            if (i != 0) {
                return i;
            }
            i = ArtifactCoords.this.artifactId.compareTo(o.getArtifactId());
            if (i != 0) {
                return i;
            }
            if (ArtifactCoords.this.version == null) {
                return o.getVersion() == null ? 0 : -1;
            }
            if (o.getVersion() == null) {
                return 1;
            }
            return ArtifactCoords.this.version.compareTo(o.getVersion());
        }
    }
}

