/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.util.CollectionUtils;
import org.wildfly.galleon.plugin.WildFlyPackageTask;
import org.wildfly.galleon.plugin.config.LineEndingsTask;
import org.wildfly.galleon.plugin.config.WildFlyPackageTasksParser;

public class WildFlyPackageTasks {
    private final List<String> mkDirs;
    private final List<LineEndingsTask> lineEndings;
    private final List<WildFlyPackageTask> tasks;

    public static Builder builder() {
        return new Builder();
    }

    public static WildFlyPackageTasks load(Path configFile) throws ProvisioningException {
        WildFlyPackageTasks wildFlyPackageTasks;
        block9: {
            InputStream configStream = Files.newInputStream(configFile, new OpenOption[0]);
            try {
                wildFlyPackageTasks = new WildFlyPackageTasksParser().parse(configStream);
                if (configStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (configStream != null) {
                        try {
                            configStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (XMLStreamException e) {
                    throw new ProvisioningException(Errors.parseXml((Path)configFile), (Throwable)e);
                }
                catch (IOException e) {
                    throw new ProvisioningException(Errors.openFile((Path)configFile), (Throwable)e);
                }
            }
            configStream.close();
        }
        return wildFlyPackageTasks;
    }

    private WildFlyPackageTasks(Builder builder) {
        this.mkDirs = CollectionUtils.unmodifiable(builder.mkDirs);
        this.lineEndings = CollectionUtils.unmodifiable(builder.lineEndings);
        this.tasks = CollectionUtils.unmodifiable(builder.tasks);
    }

    public boolean hasMkDirs() {
        return !this.mkDirs.isEmpty();
    }

    public List<String> getMkDirs() {
        return this.mkDirs;
    }

    public List<LineEndingsTask> getLineEndings() {
        return this.lineEndings;
    }

    public boolean hasTasks() {
        return !this.tasks.isEmpty();
    }

    public List<WildFlyPackageTask> getTasks() {
        return this.tasks;
    }

    public static class Builder {
        private List<String> mkDirs = Collections.emptyList();
        private List<LineEndingsTask> lineEndings = Collections.emptyList();
        private List<WildFlyPackageTask> tasks = Collections.emptyList();

        private Builder() {
        }

        public Builder addTask(WildFlyPackageTask task) {
            this.tasks = CollectionUtils.add(this.tasks, (Object)task);
            return this;
        }

        public Builder addMkDir(String mkdirs) {
            this.mkDirs = CollectionUtils.add(this.mkDirs, (Object)mkdirs);
            return this;
        }

        public Builder addLineEndings(LineEndingsTask lineEndingsTask) {
            this.lineEndings = CollectionUtils.add(this.lineEndings, (Object)lineEndingsTask);
            return this;
        }

        public WildFlyPackageTasks build() {
            return new WildFlyPackageTasks(this);
        }
    }
}

